<?php
/**
 * هدر پنل کاربر
 */
global $user;
$notifications = getUserNotifications($user['id'], true);
$unreadCount = count($notifications);
?>
<header class="fixed top-0 left-0 right-0 z-40 glass-dark">
    <div class="max-w-6xl mx-auto px-4 h-16 flex items-center justify-between">
        <!-- لوگو -->
        <a href="?page=dashboard" class="flex items-center gap-2">
            <div class="w-10 h-10 rounded-xl bg-gradient-to-r from-primary-500 to-secondary-500 flex items-center justify-center">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                </svg>
            </div>
            <span class="font-bold text-lg hidden sm:block"><?php echo getSetting('site_name', 'VPN Shop'); ?></span>
        </a>
        
        <!-- منوی دسکتاپ -->
        <nav class="hidden lg:flex items-center gap-6">
            <a href="?page=dashboard" class="text-gray-300 hover:text-white transition-colors <?php echo $_GET['page'] === 'dashboard' ? 'text-white' : ''; ?>">داشبورد</a>
            <a href="?page=shop" class="text-gray-300 hover:text-white transition-colors <?php echo $_GET['page'] === 'shop' ? 'text-white' : ''; ?>">فروشگاه</a>
            <a href="?page=configs" class="text-gray-300 hover:text-white transition-colors <?php echo $_GET['page'] === 'configs' ? 'text-white' : ''; ?>">کانفیگ‌ها</a>
            <a href="?page=tickets" class="text-gray-300 hover:text-white transition-colors <?php echo $_GET['page'] === 'tickets' ? 'text-white' : ''; ?>">پشتیبانی</a>
        </nav>
        
        <!-- آیکون‌های راست -->
        <div class="flex items-center gap-3">
            <!-- نوتیفیکیشن -->
            <div class="relative">
                <button onclick="toggleNotifications()" class="w-10 h-10 rounded-xl bg-white/10 flex items-center justify-center hover:bg-white/20 transition-colors relative">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
                    </svg>
                    <?php if ($unreadCount > 0): ?>
                        <span class="absolute -top-1 -right-1 w-5 h-5 bg-red-500 rounded-full text-xs flex items-center justify-center"><?php echo $unreadCount; ?></span>
                    <?php endif; ?>
                </button>
                
                <!-- پنل نوتیفیکیشن -->
                <div id="notificationPanel" class="hidden absolute left-0 top-12 w-80 glass rounded-2xl p-4 shadow-xl">
                    <div class="flex items-center justify-between mb-3">
                        <h4 class="font-bold">اعلان‌ها</h4>
                        <button onclick="markAllAsRead()" class="text-xs text-primary-400 hover:underline">خواندن همه</button>
                    </div>
                    <div class="space-y-2 max-h-64 overflow-y-auto">
                        <?php if (empty($notifications)): ?>
                            <p class="text-center text-gray-400 py-4 text-sm">اعلان جدیدی ندارید</p>
                        <?php else: ?>
                            <?php foreach ($notifications as $notif): ?>
                                <div class="p-3 bg-white/5 rounded-xl">
                                    <div class="font-medium text-sm"><?php echo htmlspecialchars($notif['title']); ?></div>
                                    <div class="text-xs text-gray-400 mt-1"><?php echo htmlspecialchars($notif['message']); ?></div>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <!-- پروفایل -->
            <div class="relative">
                <button onclick="toggleProfileMenu()" class="flex items-center gap-2 px-3 py-2 rounded-xl bg-white/10 hover:bg-white/20 transition-colors">
                    <div class="w-8 h-8 rounded-lg bg-gradient-to-r from-primary-500 to-secondary-500 flex items-center justify-center font-bold">
                        <?php echo strtoupper(substr($user['username'], 0, 1)); ?>
                    </div>
                    <span class="hidden sm:block text-sm"><?php echo htmlspecialchars($user['username']); ?></span>
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                
                <!-- منوی پروفایل -->
                <div id="profileMenu" class="hidden absolute left-0 top-12 w-48 glass rounded-xl overflow-hidden shadow-xl">
                    <a href="?page=profile" class="flex items-center gap-3 px-4 py-3 hover:bg-white/10 transition-colors">
                        <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                        </svg>
                        پروفایل
                    </a>
                    <a href="?page=orders" class="flex items-center gap-3 px-4 py-3 hover:bg-white/10 transition-colors">
                        <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                        </svg>
                        سفارشات
                    </a>
                    <a href="?page=referral" class="flex items-center gap-3 px-4 py-3 hover:bg-white/10 transition-colors">
                        <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                        زیرمجموعه
                    </a>
                    <div class="border-t border-white/10"></div>
                    <a href="api.php?action=logout" class="flex items-center gap-3 px-4 py-3 hover:bg-red-500/20 text-red-400 transition-colors">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                        </svg>
                        خروج
                    </a>
                </div>
            </div>
        </div>
    </div>
</header>

<script>
function toggleNotifications() {
    const panel = document.getElementById('notificationPanel');
    const profileMenu = document.getElementById('profileMenu');
    profileMenu.classList.add('hidden');
    panel.classList.toggle('hidden');
}

function toggleProfileMenu() {
    const menu = document.getElementById('profileMenu');
    const notifPanel = document.getElementById('notificationPanel');
    notifPanel.classList.add('hidden');
    menu.classList.toggle('hidden');
}

// بستن منوها با کلیک بیرون
document.addEventListener('click', function(e) {
    if (!e.target.closest('#notificationPanel') && !e.target.closest('button[onclick="toggleNotifications()"]')) {
        document.getElementById('notificationPanel').classList.add('hidden');
    }
    if (!e.target.closest('#profileMenu') && !e.target.closest('button[onclick="toggleProfileMenu()"]')) {
        document.getElementById('profileMenu').classList.add('hidden');
    }
});
</script>