<?php
/**
 * صفحه کیف پول کاربر
 */
function renderUserWallet() {
    global $user;
?>
<main class="pb-20 lg:pb-8 pt-16 min-h-screen">
    <div class="p-4 lg:p-8 max-w-4xl mx-auto">
        <!-- هدر -->
        <div class="mb-6">
            <h1 class="text-2xl font-bold">کیف پول</h1>
            <p class="text-gray-400 mt-1">مدیریت موجودی و تراکنش‌ها</p>
        </div>

        <!-- کارت موجودی -->
        <div class="glass rounded-3xl p-6 mb-6 bg-gradient-to-r from-green-500/20 to-emerald-500/20">
            <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
                <div>
                    <div class="text-sm text-gray-400 mb-1">موجودی فعلی</div>
                    <div class="text-4xl font-bold text-green-400"><?php echo number_format($user['balance']); ?></div>
                    <div class="text-gray-400">تومان</div>
                </div>
                <button onclick="openChargeModal()" class="bg-gradient-to-r from-green-500 to-emerald-500 rounded-xl px-8 py-3 font-medium hover:opacity-90 transition-opacity flex items-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                    </svg>
                    شارژ کیف پول
                </button>
            </div>
        </div>

        <!-- مبالغ پیشنهادی -->
        <div class="glass rounded-3xl p-6 mb-6">
            <h3 class="font-bold mb-4">شارژ سریع</h3>
            <div class="grid grid-cols-2 md:grid-cols-4 gap-3">
                <button onclick="selectAmount(50000)" class="amount-btn glass rounded-xl p-4 text-center hover:bg-primary-500/20 hover:border-primary-500/50 border border-transparent transition-all">
                    <div class="text-xl font-bold">۵۰,۰۰۰</div>
                    <div class="text-sm text-gray-400">تومان</div>
                </button>
                <button onclick="selectAmount(100000)" class="amount-btn glass rounded-xl p-4 text-center hover:bg-primary-500/20 hover:border-primary-500/50 border border-transparent transition-all">
                    <div class="text-xl font-bold">۱۰۰,۰۰۰</div>
                    <div class="text-sm text-gray-400">تومان</div>
                </button>
                <button onclick="selectAmount(200000)" class="amount-btn glass rounded-xl p-4 text-center hover:bg-primary-500/20 hover:border-primary-500/50 border border-transparent transition-all">
                    <div class="text-xl font-bold">۲۰۰,۰۰۰</div>
                    <div class="text-sm text-gray-400">تومان</div>
                </button>
                <button onclick="selectAmount(500000)" class="amount-btn glass rounded-xl p-4 text-center hover:bg-primary-500/20 hover:border-primary-500/50 border border-transparent transition-all">
                    <div class="text-xl font-bold">۵۰۰,۰۰۰</div>
                    <div class="text-sm text-gray-400">تومان</div>
                </button>
            </div>
        </div>

        <!-- تاریخچه تراکنش‌ها -->
        <div class="glass rounded-3xl p-6">
            <div class="flex items-center justify-between mb-4">
                <h3 class="font-bold">تاریخچه تراکنش‌ها</h3>
                <select id="transactionFilter" class="bg-white/10 border border-white/10 rounded-lg px-3 py-1.5 text-sm focus:border-primary-500 outline-none">
                    <option value="">همه</option>
                    <option value="charge">شارژ</option>
                    <option value="purchase">خرید</option>
                    <option value="refund">بازگشت</option>
                    <option value="bonus">پاداش</option>
                </select>
            </div>
            
            <div id="transactionsList" class="space-y-3">
                <!-- تراکنش‌ها با AJAX لود می‌شوند -->
            </div>
            
            <div id="noTransactions" class="hidden text-center py-8 text-gray-400">
                <svg class="w-16 h-16 mx-auto mb-4 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                </svg>
                <p>تراکنشی یافت نشد</p>
            </div>
            
            <!-- صفحه‌بندی -->
            <div id="transactionsPagination" class="flex items-center justify-center gap-2 mt-4"></div>
        </div>
    </div>
</main>

<!-- Modal شارژ کیف پول -->
<div id="chargeModal" class="fixed inset-0 z-50 hidden items-center justify-center p-4 bg-black/50 backdrop-blur-sm">
    <div class="glass rounded-3xl p-6 w-full max-w-md animate-scale-in">
        <div class="flex items-center justify-between mb-6">
            <h3 class="text-lg font-bold">شارژ کیف پول</h3>
            <button onclick="closeChargeModal()" class="w-8 h-8 rounded-full bg-white/10 flex items-center justify-center hover:bg-red-500/20">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>
        
        <form id="chargeForm" class="space-y-4">
            <div>
                <label class="block text-sm text-gray-400 mb-2">مبلغ شارژ (تومان)</label>
                <input type="number" name="amount" id="chargeAmount" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none text-xl text-center" placeholder="50,000" min="10000" required>
                <p class="text-xs text-gray-500 mt-1">حداقل مبلغ: ۱۰,۰۰۰ تومان</p>
            </div>
            
            <!-- اطلاعات کارت بانکی -->
            <div class="glass rounded-xl p-4">
                <div class="text-center mb-3">
                    <div class="text-sm text-gray-400 mb-1">واریز به شماره کارت</div>
                    <div class="text-xl font-mono font-bold text-primary-400" id="chargeCardNumber">6037-9974-1234-5678</div>
                    <div class="text-sm text-gray-400 mt-1" id="chargeCardHolder">نام صاحب کارت</div>
                </div>
                <button type="button" onclick="copyChargeCard()" class="w-full py-2 rounded-lg bg-white/10 hover:bg-white/20 text-sm">
                    کپی شماره کارت
                </button>
            </div>
            
            <div>
                <label class="block text-sm text-gray-400 mb-2">آپلود رسید پرداخت</label>
                <div class="border-2 border-dashed border-white/20 rounded-xl p-6 text-center hover:border-primary-500/50 transition-colors cursor-pointer" onclick="document.getElementById('chargeReceiptInput').click()">
                    <input type="file" id="chargeReceiptInput" name="receipt" class="hidden" accept="image/*" required>
                    <div id="chargeReceiptPreview" class="hidden mb-3">
                        <img src="" alt="رسید" class="max-h-32 mx-auto rounded-lg">
                    </div>
                    <div id="chargeReceiptPlaceholder">
                        <svg class="w-12 h-12 mx-auto text-gray-400 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                        </svg>
                        <p class="text-sm text-gray-400">تصویر رسید پرداخت را آپلود کنید</p>
                    </div>
                </div>
            </div>
            
            <button type="submit" id="chargeBtn" class="w-full bg-gradient-to-r from-green-500 to-emerald-500 rounded-xl py-3 font-medium hover:opacity-90 transition-opacity">
                ثبت درخواست شارژ
            </button>
        </form>
    </div>
</div>

<?php renderMobileNav(); ?>

<script>
// انتخاب مبلغ
function selectAmount(amount) {
    document.querySelectorAll('.amount-btn').forEach(btn => {
        btn.classList.remove('bg-primary-500/20', 'border-primary-500/50');
    });
    event.currentTarget.classList.add('bg-primary-500/20', 'border-primary-500/50');
    
    document.getElementById('chargeAmount').value = amount;
    openChargeModal();
}

// Modal شارژ
function openChargeModal() {
    loadBankCardForCharge();
    document.getElementById('chargeModal').classList.remove('hidden');
    document.getElementById('chargeModal').classList.add('flex');
}

function closeChargeModal() {
    document.getElementById('chargeModal').classList.add('hidden');
    document.getElementById('chargeModal').classList.remove('flex');
}

async function loadBankCardForCharge() {
    try {
        const response = await fetch('api.php?action=get_bank_card');
        const data = await response.json();
        
        if (data.success) {
            document.getElementById('chargeCardNumber').textContent = data.card_number;
            document.getElementById('chargeCardHolder').textContent = data.card_holder;
        }
    } catch (error) {
        console.error('Error loading bank card:', error);
    }
}

function copyChargeCard() {
    const cardNumber = document.getElementById('chargeCardNumber').textContent.replace(/-/g, '');
    navigator.clipboard.writeText(cardNumber);
    showToast('شماره کارت کپی شد', 'success');
}

// پیش‌نمایش رسید
document.getElementById('chargeReceiptInput')?.addEventListener('change', function() {
    const file = this.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            document.getElementById('chargeReceiptPreview').classList.remove('hidden');
            document.getElementById('chargeReceiptPreview').querySelector('img').src = e.target.result;
            document.getElementById('chargeReceiptPlaceholder').classList.add('hidden');
        };
        reader.readAsDataURL(file);
    }
});

// ثبت درخواست شارژ
document.getElementById('chargeForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    formData.append('action', 'request_charge');
    
    const btn = document.getElementById('chargeBtn');
    btn.disabled = true;
    btn.textContent = 'در حال ارسال...';
    
    try {
        const response = await fetch('api.php', { method: 'POST', body: formData });
        const data = await response.json();
        
        if (data.success) {
            closeChargeModal();
            showToast('درخواست شارژ ثبت شد. پس از تایید، موجودی اضافه می‌شود', 'success');
            loadTransactions();
        } else {
            showToast(data.message, 'error');
        }
    } catch (error) {
        showToast('خطا در ثبت درخواست', 'error');
    } finally {
        btn.disabled = false;
        btn.textContent = 'ثبت درخواست شارژ';
    }
});

// لود تراکنش‌ها
async function loadTransactions(page = 1) {
    const filter = document.getElementById('transactionFilter').value;
    
    try {
        const response = await fetch(`api.php?action=get_transactions&type=${filter}&page=${page}`);
        const data = await response.json();
        
        if (data.success) {
            renderTransactions(data.transactions);
        }
    } catch (error) {
        console.error('Error loading transactions:', error);
    }
}

function renderTransactions(transactions) {
    const container = document.getElementById('transactionsList');
    const noTransactions = document.getElementById('noTransactions');
    
    if (transactions.length === 0) {
        container.innerHTML = '';
        noTransactions.classList.remove('hidden');
        return;
    }
    
    noTransactions.classList.add('hidden');
    container.innerHTML = transactions.map(tx => `
        <div class="flex items-center justify-between p-4 bg-white/5 rounded-xl">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 rounded-xl ${getTransactionIconClass(tx.type)} flex items-center justify-center">
                    ${getTransactionIcon(tx.type)}
                </div>
                <div>
                    <div class="font-medium">${getTransactionTitle(tx.type)}</div>
                    <div class="text-sm text-gray-400">${tx.description || ''}</div>
                    <div class="text-xs text-gray-500">${tx.created_at}</div>
                </div>
            </div>
            <div class="text-left">
                <div class="font-bold ${tx.amount > 0 ? 'text-green-400' : 'text-red-400'}">
                    ${tx.amount > 0 ? '+' : ''}${numberFormat(tx.amount)} تومان
                </div>
                <div class="text-xs">
                    <span class="px-2 py-0.5 rounded ${getTransactionStatusClass(tx.status)}">
                        ${getTransactionStatusText(tx.status)}
                    </span>
                </div>
            </div>
        </div>
    `).join('');
}

// توابع کمکی
function getTransactionIconClass(type) {
    const classes = {
        'charge': 'bg-green-500/20',
        'purchase': 'bg-blue-500/20',
        'refund': 'bg-yellow-500/20',
        'bonus': 'bg-purple-500/20',
        'referral': 'bg-pink-500/20'
    };
    return classes[type] || 'bg-gray-500/20';
}

function getTransactionIcon(type) {
    const icons = {
        'charge': '<svg class="w-5 h-5 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path></svg>',
        'purchase': '<svg class="w-5 h-5 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>',
        'refund': '<svg class="w-5 h-5 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h10a8 8 0 018 8v2M3 10l6 6m-6-6l6-6"></path></svg>',
        'bonus': '<svg class="w-5 h-5 text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v13m0-13V6a2 2 0 112 2h-2zm0 0V5.5A2.5 2.5 0 109.5 8H12zm-7 4h14M5 12a2 2 0 110-4h14a2 2 0 110 4M5 12v7a2 2 0 002 2h10a2 2 0 002-2v-7"></path></svg>'
    };
    return icons[type] || icons['charge'];
}

function getTransactionTitle(type) {
    const titles = {
        'charge': 'شارژ کیف پول',
        'purchase': 'خرید',
        'refund': 'بازگشت وجه',
        'bonus': 'پاداش',
        'referral': 'کمیسیون معرفی'
    };
    return titles[type] || type;
}

function getTransactionStatusClass(status) {
    const classes = {
        'completed': 'bg-green-500/20 text-green-400',
        'pending': 'bg-yellow-500/20 text-yellow-400',
        'failed': 'bg-red-500/20 text-red-400'
    };
    return classes[status] || classes['pending'];
}

function getTransactionStatusText(status) {
    const texts = {
        'completed': 'موفق',
        'pending': 'در انتظار',
        'failed': 'ناموفق'
    };
    return texts[status] || status;
}

document.getElementById('transactionFilter')?.addEventListener('change', () => loadTransactions());

// لود اولیه
document.addEventListener('DOMContentLoaded', loadTransactions);
</script>
<?php
}
?>