<?php
/**
 * صفحه فروشگاه کاربر
 */
function renderUserShop() {
    global $user;
?>
<main class="pb-20 lg:pb-8 pt-16 min-h-screen">
    <div class="p-4 lg:p-8 max-w-6xl mx-auto">
        <!-- هدر صفحه -->
        <div class="mb-6">
            <h1 class="text-2xl font-bold">فروشگاه</h1>
            <p class="text-gray-400 mt-1">خرید کانفیگ VPN با بهترین کیفیت</p>
        </div>

        <!-- موجودی کیف پول -->
        <div class="glass rounded-2xl p-4 mb-6 flex items-center justify-between">
            <div class="flex items-center gap-3">
                <div class="w-12 h-12 rounded-xl bg-green-500/20 flex items-center justify-center">
                    <svg class="w-6 h-6 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                    </svg>
                </div>
                <div>
                    <div class="text-sm text-gray-400">موجودی کیف پول</div>
                    <div class="text-xl font-bold text-green-400"><?php echo number_format($user['balance']); ?> تومان</div>
                </div>
            </div>
            <a href="?page=wallet" class="px-4 py-2 rounded-xl bg-green-500/20 text-green-400 hover:bg-green-500/30 transition-colors text-sm">
                شارژ کیف پول
            </a>
        </div>

        <!-- فیلترها -->
        <div class="glass rounded-2xl p-4 mb-6">
            <div class="flex flex-wrap items-center gap-3">
                <!-- فیلتر نوع -->
                <div class="flex items-center gap-2 overflow-x-auto pb-2">
                    <button onclick="filterProducts('all')" class="product-type-filter active px-4 py-2 rounded-xl bg-primary-500 text-white text-sm whitespace-nowrap" data-type="all">
                        همه
                    </button>
                    <button onclick="filterProducts('vless')" class="product-type-filter px-4 py-2 rounded-xl bg-white/10 hover:bg-white/20 text-sm whitespace-nowrap" data-type="vless">
                        VLESS
                    </button>
                    <button onclick="filterProducts('vmess')" class="product-type-filter px-4 py-2 rounded-xl bg-white/10 hover:bg-white/20 text-sm whitespace-nowrap" data-type="vmess">
                        VMess
                    </button>
                    <button onclick="filterProducts('trojan')" class="product-type-filter px-4 py-2 rounded-xl bg-white/10 hover:bg-white/20 text-sm whitespace-nowrap" data-type="trojan">
                        Trojan
                    </button>
                    <button onclick="filterProducts('netmod')" class="product-type-filter px-4 py-2 rounded-xl bg-white/10 hover:bg-white/20 text-sm whitespace-nowrap" data-type="netmod">
                        NetMod
                    </button>
                </div>
                
                <!-- فیلتر لوکیشن -->
                <select id="locationFilter" onchange="applyFilters()" class="bg-white/10 border border-white/10 rounded-xl px-4 py-2 text-sm focus:border-primary-500 outline-none">
                    <option value="">همه لوکیشن‌ها</option>
                    <option value="germany">🇩🇪 آلمان</option>
                    <option value="netherlands">🇳🇱 هلند</option>
                    <option value="france">🇫🇷 فرانسه</option>
                    <option value="usa">🇺🇸 آمریکا</option>
                    <option value="uk">🇬🇧 انگلستان</option>
                    <option value="turkey">🇹🇷 ترکیه</option>
                </select>
                
                <!-- مرتب‌سازی -->
                <select id="sortFilter" onchange="applyFilters()" class="bg-white/10 border border-white/10 rounded-xl px-4 py-2 text-sm focus:border-primary-500 outline-none">
                    <option value="popular">پرفروش‌ترین</option>
                    <option value="price_asc">ارزان‌ترین</option>
                    <option value="price_desc">گران‌ترین</option>
                    <option value="newest">جدیدترین</option>
                </select>
            </div>
        </div>

        <!-- لیست محصولات -->
        <div id="productsList" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            <!-- محصولات با AJAX لود می‌شوند -->
        </div>
        
        <!-- Loading -->
        <div id="productsLoading" class="text-center py-12">
            <div class="inline-block w-8 h-8 border-4 border-primary-500 border-t-transparent rounded-full animate-spin"></div>
        </div>
    </div>
</main>

<!-- Modal خرید -->
<div id="purchaseModal" class="fixed inset-0 z-50 hidden items-center justify-center p-4 bg-black/50 backdrop-blur-sm">
    <div class="glass rounded-3xl p-6 w-full max-w-md animate-scale-in max-h-[90vh] overflow-y-auto">
        <div class="flex items-center justify-between mb-6">
            <h3 class="text-lg font-bold">تکمیل خرید</h3>
            <button onclick="closePurchaseModal()" class="w-8 h-8 rounded-full bg-white/10 flex items-center justify-center hover:bg-red-500/20">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>
        
        <!-- اطلاعات محصول -->
        <div class="glass rounded-xl p-4 mb-4">
            <div class="flex items-center gap-3 mb-3">
                <div class="w-12 h-12 rounded-xl bg-gradient-to-r from-primary-500 to-secondary-500 flex items-center justify-center" id="modalProductIcon">
                    🌍
                </div>
                <div>
                    <div class="font-bold" id="modalProductName">نام محصول</div>
                    <div class="text-sm text-gray-400" id="modalProductType">نوع</div>
                </div>
            </div>
            <div class="flex items-center justify-between text-sm">
                <span class="text-gray-400">مدت زمان:</span>
                <span id="modalProductDuration">30 روز</span>
            </div>
            <div class="flex items-center justify-between text-sm mt-1">
                <span class="text-gray-400">حجم ترافیک:</span>
                <span id="modalProductTraffic">نامحدود</span>
            </div>
        </div>
        
        <form id="purchaseForm" class="space-y-4">
            <input type="hidden" name="product_id" id="purchaseProductId">
            
            <!-- کد تخفیف -->
            <div>
                <label class="block text-sm text-gray-400 mb-2">کد تخفیف (اختیاری)</label>
                <div class="flex gap-2">
                    <input type="text" name="discount_code" id="discountCode" class="flex-1 bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" placeholder="کد تخفیف">
                    <button type="button" onclick="applyDiscount()" class="px-4 py-3 rounded-xl bg-white/10 hover:bg-white/20 transition-colors">
                        اعمال
                    </button>
                </div>
                <p id="discountMessage" class="text-sm mt-1 hidden"></p>
            </div>
            
            <!-- روش پرداخت -->
            <div>
                <label class="block text-sm text-gray-400 mb-2">روش پرداخت</label>
                <div class="grid grid-cols-2 gap-3">
                    <label class="glass rounded-xl p-4 cursor-pointer border-2 border-transparent has-[:checked]:border-green-500 transition-all">
                        <input type="radio" name="payment_method" value="wallet" class="hidden" checked>
                        <div class="flex flex-col items-center gap-2">
                            <div class="w-10 h-10 rounded-xl bg-green-500/20 flex items-center justify-center">
                                <svg class="w-5 h-5 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                                </svg>
                            </div>
                            <span class="text-sm font-medium">کیف پول</span>
                            <span class="text-xs text-gray-400"><?php echo number_format($user['balance']); ?> تومان</span>
                        </div>
                    </label>
                    <label class="glass rounded-xl p-4 cursor-pointer border-2 border-transparent has-[:checked]:border-blue-500 transition-all">
                        <input type="radio" name="payment_method" value="card" class="hidden">
                        <div class="flex flex-col items-center gap-2">
                            <div class="w-10 h-10 rounded-xl bg-blue-500/20 flex items-center justify-center">
                                <svg class="w-5 h-5 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                                </svg>
                            </div>
                            <span class="text-sm font-medium">کارت به کارت</span>
                            <span class="text-xs text-gray-400">پرداخت دستی</span>
                        </div>
                    </label>
                </div>
            </div>
            
            <!-- اطلاعات کارت (برای کارت به کارت) -->
            <div id="cardPaymentInfo" class="hidden">
                <div class="glass rounded-xl p-4 mb-4">
                    <div class="text-center mb-3">
                        <div class="text-sm text-gray-400 mb-1">واریز به شماره کارت</div>
                        <div class="text-xl font-mono font-bold text-primary-400" id="bankCardNumber">6037-9974-1234-5678</div>
                        <div class="text-sm text-gray-400 mt-1" id="bankCardHolder">نام صاحب کارت</div>
                    </div>
                    <button type="button" onclick="copyCardNumber()" class="w-full py-2 rounded-lg bg-white/10 hover:bg-white/20 text-sm">
                        کپی شماره کارت
                    </button>
                </div>
                <div>
                    <label class="block text-sm text-gray-400 mb-2">آپلود رسید پرداخت</label>
                    <div class="border-2 border-dashed border-white/20 rounded-xl p-6 text-center hover:border-primary-500/50 transition-colors cursor-pointer" onclick="document.getElementById('receiptInput').click()">
                        <input type="file" id="receiptInput" name="receipt" class="hidden" accept="image/*">
                        <div id="receiptPreview" class="hidden mb-3">
                            <img src="" alt="رسید" class="max-h-32 mx-auto rounded-lg">
                        </div>
                        <div id="receiptPlaceholder">
                            <svg class="w-12 h-12 mx-auto text-gray-400 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                            </svg>
                            <p class="text-sm text-gray-400">کلیک کنید یا تصویر را بکشید</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- خلاصه پرداخت -->
            <div class="glass rounded-xl p-4">
                <div class="flex items-center justify-between mb-2">
                    <span class="text-gray-400">قیمت محصول:</span>
                    <span id="originalPrice">0 تومان</span>
                </div>
                <div id="discountRow" class="flex items-center justify-between mb-2 hidden">
                    <span class="text-green-400">تخفیف:</span>
                    <span class="text-green-400" id="discountAmount">- 0 تومان</span>
                </div>
                <div class="flex items-center justify-between pt-2 border-t border-white/10">
                    <span class="font-bold">مبلغ قابل پرداخت:</span>
                    <span class="text-xl font-bold text-primary-400" id="finalPrice">0 تومان</span>
                </div>
            </div>
            
            <button type="submit" id="purchaseBtn" class="w-full bg-gradient-to-r from-primary-500 to-secondary-500 rounded-xl py-3 font-medium hover:opacity-90 transition-opacity flex items-center justify-center gap-2">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"></path>
                </svg>
                تکمیل خرید
            </button>
        </form>
    </div>
</div>

<!-- منوی پایین موبایل -->
<?php renderMobileNav(); ?>

<script>
let currentProductType = 'all';
let selectedProduct = null;
let discountPercent = 0;

// لود محصولات
async function loadProducts() {
    const location = document.getElementById('locationFilter').value;
    const sort = document.getElementById('sortFilter').value;
    
    document.getElementById('productsLoading').classList.remove('hidden');
    document.getElementById('productsList').innerHTML = '';
    
    try {
        const response = await fetch(`api.php?action=get_products&type=${currentProductType}&location=${location}&sort=${sort}`);
        const data = await response.json();
        
        document.getElementById('productsLoading').classList.add('hidden');
        
        if (data.success) {
            renderProducts(data.products);
        }
    } catch (error) {
        document.getElementById('productsLoading').classList.add('hidden');
        console.error('Error loading products:', error);
    }
}

function renderProducts(products) {
    const container = document.getElementById('productsList');
    
    if (products.length === 0) {
        container.innerHTML = `
            <div class="col-span-full text-center py-12 text-gray-400">
                <svg class="w-16 h-16 mx-auto mb-4 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4"></path>
                </svg>
                <p>محصولی یافت نشد</p>
            </div>
        `;
        return;
    }
    
    container.innerHTML = products.map(product => `
        <div class="glass rounded-2xl overflow-hidden hover:scale-[1.02] transition-transform">
            <!-- هدر محصول -->
            <div class="bg-gradient-to-r ${getProductGradient(product.type)} p-4">
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-3">
                        <span class="text-3xl">${getLocationFlag(product.location)}</span>
                        <div>
                            <div class="font-bold">${product.name}</div>
                            <div class="text-sm opacity-80">${getLocationName(product.location)}</div>
                        </div>
                    </div>
                    <span class="px-2 py-1 rounded-lg bg-white/20 text-xs font-medium">${product.type.toUpperCase()}</span>
                </div>
            </div>
            
            <!-- محتوای محصول -->
            <div class="p-4">
                <div class="space-y-2 mb-4">
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-400 flex items-center gap-2">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            مدت زمان
                        </span>
                        <span>${product.duration} روز</span>
                    </div>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-400 flex items-center gap-2">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4"></path>
                            </svg>
                            حجم ترافیک
                        </span>
                        <span>${product.traffic ? product.traffic + ' GB' : 'نامحدود'}</span>
                    </div>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-400 flex items-center gap-2">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                            </svg>
                            حداکثر دستگاه
                        </span>
                        <span>${product.max_devices} دستگاه</span>
                    </div>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-400 flex items-center gap-2">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                            موجودی
                        </span>
                        <span class="${product.stock > 0 ? 'text-green-400' : 'text-red-400'}">${product.stock > 0 ? product.stock + ' عدد' : 'ناموجود'}</span>
                    </div>
                </div>
                
                <!-- قیمت و خرید -->
                <div class="flex items-center justify-between pt-4 border-t border-white/10">
                    <div>
                        ${product.old_price ? `<div class="text-sm text-gray-400 line-through">${numberFormat(product.old_price)} تومان</div>` : ''}
                        <div class="text-xl font-bold text-primary-400">${numberFormat(product.price)} تومان</div>
                    </div>
                    <button onclick='openPurchaseModal(${JSON.stringify(product)})' class="px-6 py-2.5 rounded-xl bg-gradient-to-r from-primary-500 to-secondary-500 font-medium hover:opacity-90 transition-opacity ${product.stock <= 0 ? 'opacity-50 cursor-not-allowed' : ''}" ${product.stock <= 0 ? 'disabled' : ''}>
                        ${product.stock > 0 ? 'خرید' : 'ناموجود'}
                    </button>
                </div>
            </div>
        </div>
    `).join('');
}

// فیلتر محصولات
function filterProducts(type) {
    currentProductType = type;
    
    document.querySelectorAll('.product-type-filter').forEach(btn => {
        if (btn.dataset.type === type) {
            btn.classList.add('active', 'bg-primary-500', 'text-white');
            btn.classList.remove('bg-white/10');
        } else {
            btn.classList.remove('active', 'bg-primary-500', 'text-white');
            btn.classList.add('bg-white/10');
        }
    });
    
    loadProducts();
}

function applyFilters() {
    loadProducts();
}

// Modal خرید
function openPurchaseModal(product) {
    selectedProduct = product;
    discountPercent = 0;
    
    document.getElementById('purchaseProductId').value = product.id;
    document.getElementById('modalProductIcon').textContent = getLocationFlag(product.location);
    document.getElementById('modalProductName').textContent = product.name;
    document.getElementById('modalProductType').textContent = product.type.toUpperCase() + ' • ' + getLocationName(product.location);
    document.getElementById('modalProductDuration').textContent = product.duration + ' روز';
    document.getElementById('modalProductTraffic').textContent = product.traffic ? product.traffic + ' GB' : 'نامحدود';
    document.getElementById('originalPrice').textContent = numberFormat(product.price) + ' تومان';
    document.getElementById('finalPrice').textContent = numberFormat(product.price) + ' تومان';
    document.getElementById('discountRow').classList.add('hidden');
    document.getElementById('discountCode').value = '';
    document.getElementById('discountMessage').classList.add('hidden');
    
    // بارگذاری اطلاعات کارت بانکی
    loadBankCard();
    
    document.getElementById('purchaseModal').classList.remove('hidden');
    document.getElementById('purchaseModal').classList.add('flex');
}

function closePurchaseModal() {
    document.getElementById('purchaseModal').classList.add('hidden');
    document.getElementById('purchaseModal').classList.remove('flex');
    selectedProduct = null;
}

// بارگذاری اطلاعات کارت
async function loadBankCard() {
    try {
        const response = await fetch('api.php?action=get_bank_card');
        const data = await response.json();
        
        if (data.success) {
            document.getElementById('bankCardNumber').textContent = data.card_number;
            document.getElementById('bankCardHolder').textContent = data.card_holder;
        }
    } catch (error) {
        console.error('Error loading bank card:', error);
    }
}

// اعمال کد تخفیف
async function applyDiscount() {
    const code = document.getElementById('discountCode').value.trim();
    if (!code) return;
    
    try {
        const response = await fetch(`api.php?action=check_discount&code=${code}&product_id=${selectedProduct.id}`);
        const data = await response.json();
        
        const messageEl = document.getElementById('discountMessage');
        
        if (data.success) {
            discountPercent = data.discount;
            const discountValue = Math.floor(selectedProduct.price * discountPercent / 100);
            const finalPrice = selectedProduct.price - discountValue;
            
            document.getElementById('discountAmount').textContent = '- ' + numberFormat(discountValue) + ' تومان';
            document.getElementById('finalPrice').textContent = numberFormat(finalPrice) + ' تومان';
            document.getElementById('discountRow').classList.remove('hidden');
            
            messageEl.textContent = `✓ کد تخفیف ${discountPercent}% اعمال شد`;
            messageEl.className = 'text-sm mt-1 text-green-400';
        } else {
            messageEl.textContent = data.message;
            messageEl.className = 'text-sm mt-1 text-red-400';
        }
        
        messageEl.classList.remove('hidden');
    } catch (error) {
        console.error('Error checking discount:', error);
    }
}

// نمایش/مخفی کردن اطلاعات کارت
document.querySelectorAll('input[name="payment_method"]').forEach(radio => {
    radio.addEventListener('change', function() {
        const cardInfo = document.getElementById('cardPaymentInfo');
        if (this.value === 'card') {
            cardInfo.classList.remove('hidden');
        } else {
            cardInfo.classList.add('hidden');
        }
    });
});

// پیش‌نمایش رسید
document.getElementById('receiptInput')?.addEventListener('change', function() {
    const file = this.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            document.getElementById('receiptPreview').classList.remove('hidden');
            document.getElementById('receiptPreview').querySelector('img').src = e.target.result;
            document.getElementById('receiptPlaceholder').classList.add('hidden');
        };
        reader.readAsDataURL(file);
    }
});

// کپی شماره کارت
function copyCardNumber() {
    const cardNumber = document.getElementById('bankCardNumber').textContent.replace(/-/g, '');
    navigator.clipboard.writeText(cardNumber);
    showToast('شماره کارت کپی شد', 'success');
}

// ثبت سفارش
document.getElementById('purchaseForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    formData.append('action', 'create_order');
    formData.append('discount_percent', discountPercent);
    
    const btn = document.getElementById('purchaseBtn');
    btn.disabled = true;
    btn.innerHTML = '<div class="w-5 h-5 border-2 border-white border-t-transparent rounded-full animate-spin"></div>';
    
    try {
        const response = await fetch('api.php', { method: 'POST', body: formData });
        const data = await response.json();
        
        if (data.success) {
            closePurchaseModal();
            
            if (data.payment_method === 'wallet') {
                showToast('خرید با موفقیت انجام شد!', 'success');
                setTimeout(() => window.location.href = '?page=configs', 1500);
            } else {
                showToast('سفارش ثبت شد. پس از تایید پرداخت، کانفیگ فعال می‌شود', 'success');
                setTimeout(() => window.location.href = '?page=orders', 1500);
            }
        } else {
            showToast(data.message, 'error');
        }
    } catch (error) {
        showToast('خطا در ثبت سفارش', 'error');
    } finally {
        btn.disabled = false;
        btn.innerHTML = `
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"></path>
            </svg>
            تکمیل خرید
        `;
    }
});

// توابع کمکی
function getProductGradient(type) {
    const gradients = {
        'vless': 'from-blue-500 to-cyan-500',
        'vmess': 'from-green-500 to-emerald-500',
        'trojan': 'from-purple-500 to-pink-500',
        'shadowsocks': 'from-yellow-500 to-orange-500',
        'netmod': 'from-pink-500 to-rose-500'
    };
    return gradients[type] || gradients['vless'];
}

function getLocationFlag(location) {
    const flags = {
        'germany': '🇩🇪', 'netherlands': '🇳🇱', 'france': '🇫🇷', 'usa': '🇺🇸',
        'uk': '🇬🇧', 'canada': '🇨🇦', 'singapore': '🇸🇬', 'turkey': '🇹🇷', 'uae': '🇦🇪'
    };
    return flags[location] || '🌍';
}

function getLocationName(location) {
    const names = {
        'germany': 'آلمان', 'netherlands': 'هلند', 'france': 'فرانسه', 'usa': 'آمریکا',
        'uk': 'انگلستان', 'canada': 'کانادا', 'singapore': 'سنگاپور', 'turkey': 'ترکیه', 'uae': 'امارات'
    };
    return names[location] || location;
}

// لود اولیه
document.addEventListener('DOMContentLoaded', loadProducts);
</script>
<?php
}
?>