<?php
/**
 * صفحه پروفایل کاربر
 */
global $user;
?>
<main class="pb-20 lg:pb-8 pt-16 min-h-screen">
    <div class="p-4 lg:p-8 max-w-4xl mx-auto">
        <!-- هدر -->
        <div class="mb-6">
            <h1 class="text-2xl font-bold">پروفایل کاربری</h1>
            <p class="text-gray-400 mt-1">مدیریت اطلاعات حساب کاربری</p>
        </div>

        <!-- کارت پروفایل -->
        <div class="glass rounded-3xl p-6 mb-6">
            <div class="flex flex-col md:flex-row items-center gap-6">
                <div class="w-24 h-24 rounded-2xl bg-gradient-to-r from-primary-500 to-secondary-500 flex items-center justify-center text-4xl font-bold">
                    <?php echo strtoupper(substr($user['username'], 0, 1)); ?>
                </div>
                <div class="text-center md:text-right flex-1">
                    <h2 class="text-2xl font-bold"><?php echo htmlspecialchars($user['username']); ?></h2>
                    <p class="text-gray-400"><?php echo htmlspecialchars($user['phone']); ?></p>
                    <div class="flex items-center justify-center md:justify-start gap-3 mt-3">
                        <span class="px-3 py-1 rounded-full text-sm <?php echo $user['role'] === 'vip' ? 'bg-yellow-500/20 text-yellow-400' : 'bg-blue-500/20 text-blue-400'; ?>">
                            <?php echo $user['role'] === 'vip' ? 'VIP' : 'کاربر عادی'; ?>
                        </span>
                        <span class="text-gray-400 text-sm">
                            عضویت از <?php echo toJalali($user['created_at'], 'Y/m/d'); ?>
                        </span>
                    </div>
                </div>
                <div class="text-center glass rounded-2xl p-4">
                    <div class="text-sm text-gray-400 mb-1">موجودی</div>
                    <div class="text-2xl font-bold text-green-400"><?php echo number_format($user['balance']); ?></div>
                    <div class="text-sm text-gray-400">تومان</div>
                </div>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <!-- ویرایش اطلاعات -->
            <div class="glass rounded-3xl p-6">
                <h3 class="font-bold mb-4 flex items-center gap-2">
                    <svg class="w-5 h-5 text-primary-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                    </svg>
                    اطلاعات شخصی
                </h3>
                <form id="profileForm" class="space-y-4">
                    <div>
                        <label class="block text-sm text-gray-400 mb-2">نام کاربری</label>
                        <input type="text" name="username" value="<?php echo htmlspecialchars($user['username']); ?>" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" readonly>
                        <p class="text-xs text-gray-500 mt-1">نام کاربری قابل تغییر نیست</p>
                    </div>
                    <div>
                        <label class="block text-sm text-gray-400 mb-2">ایمیل</label>
                        <input type="email" name="email" value="<?php echo htmlspecialchars($user['email'] ?? ''); ?>" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" placeholder="example@email.com">
                    </div>
                    <div>
                        <label class="block text-sm text-gray-400 mb-2">شماره موبایل</label>
                        <input type="tel" name="phone" value="<?php echo htmlspecialchars($user['phone']); ?>" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" readonly>
                    </div>
                    <button type="submit" class="w-full bg-gradient-to-r from-primary-500 to-secondary-500 rounded-xl py-3 font-medium hover:opacity-90 transition-opacity">
                        ذخیره تغییرات
                    </button>
                </form>
            </div>

            <!-- تغییر رمز عبور -->
            <div class="glass rounded-3xl p-6">
                <h3 class="font-bold mb-4 flex items-center gap-2">
                    <svg class="w-5 h-5 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                    </svg>
                    تغییر رمز عبور
                </h3>
                <form id="passwordForm" class="space-y-4">
                    <div>
                        <label class="block text-sm text-gray-400 mb-2">رمز عبور فعلی</label>
                        <input type="password" name="current_password" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" required>
                    </div>
                    <div>
                        <label class="block text-sm text-gray-400 mb-2">رمز عبور جدید</label>
                        <input type="password" name="new_password" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" required minlength="6">
                    </div>
                    <div>
                        <label class="block text-sm text-gray-400 mb-2">تکرار رمز عبور</label>
                        <input type="password" name="confirm_password" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" required>
                    </div>
                    <button type="submit" class="w-full glass rounded-xl py-3 font-medium hover:bg-white/10 transition-colors border border-yellow-500/50 text-yellow-400">
                        تغییر رمز عبور
                    </button>
                </form>
            </div>
        </div>

        <!-- دستگاه‌های متصل -->
        <div class="glass rounded-3xl p-6 mt-6">
            <div class="flex items-center justify-between mb-4">
                <h3 class="font-bold flex items-center gap-2">
                    <svg class="w-5 h-5 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                    </svg>
                    دستگاه‌های متصل
                </h3>
                <span class="text-sm text-gray-400">حداکثر <?php echo $user['max_devices']; ?> دستگاه</span>
            </div>
            <div id="devicesList" class="space-y-3">
                <!-- دستگاه‌ها با AJAX لود می‌شوند -->
            </div>
        </div>

        <!-- تاریخچه ورود -->
        <div class="glass rounded-3xl p-6 mt-6">
            <h3 class="font-bold mb-4 flex items-center gap-2">
                <svg class="w-5 h-5 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                آخرین فعالیت‌ها
            </h3>
            <div class="space-y-2">
                <div class="flex items-center justify-between p-3 bg-white/5 rounded-xl">
                    <div class="flex items-center gap-3">
                        <div class="w-8 h-8 rounded-lg bg-green-500/20 flex items-center justify-center">
                            <svg class="w-4 h-4 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"></path>
                            </svg>
                        </div>
                        <div>
                            <div class="font-medium text-sm">آخرین ورود</div>
                            <div class="text-xs text-gray-400"><?php echo $user['last_ip'] ?? 'نامشخص'; ?></div>
                        </div>
                    </div>
                    <div class="text-sm text-gray-400"><?php echo $user['last_login'] ? toJalali($user['last_login']) : 'هرگز'; ?></div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php renderMobileNav(); ?>

<script>
// لود دستگاه‌ها
async function loadDevices() {
    try {
        const response = await fetch('api.php?action=get_user_devices');
        const data = await response.json();
        
        if (data.success) {
            const container = document.getElementById('devicesList');
            if (data.devices.length === 0) {
                container.innerHTML = '<p class="text-center text-gray-400 py-4">دستگاهی متصل نیست</p>';
                return;
            }
            
            container.innerHTML = data.devices.map(device => `
                <div class="flex items-center justify-between p-3 bg-white/5 rounded-xl">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 rounded-xl bg-blue-500/20 flex items-center justify-center">
                            <svg class="w-5 h-5 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 18h.01M8 21h8a2 2 0 002-2V5a2 2 0 00-2-2H8a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                            </svg>
                        </div>
                        <div>
                            <div class="font-medium text-sm">${device.device_name || 'دستگاه ناشناس'}</div>
                            <div class="text-xs text-gray-400">${device.ip_address} • ${device.last_connect}</div>
                        </div>
                    </div>
                    <button onclick="removeDevice(${device.id})" class="text-red-400 hover:text-red-300 p-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                        </svg>
                    </button>
                </div>
            `).join('');
        }
    } catch (error) {
        console.error('Error loading devices:', error);
    }
}

// ذخیره پروفایل
document.getElementById('profileForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    formData.append('action', 'update_profile');
    
    try {
        const response = await fetch('api.php', { method: 'POST', body: formData });
        const data = await response.json();
        showToast(data.message, data.success ? 'success' : 'error');
    } catch (error) {
        showToast('خطا در ذخیره اطلاعات', 'error');
    }
});

// تغییر رمز عبور
document.getElementById('passwordForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    if (formData.get('new_password') !== formData.get('confirm_password')) {
        showToast('رمز عبور و تکرار آن مطابقت ندارند', 'error');
        return;
    }
    
    formData.append('action', 'change_password');
    
    try {
        const response = await fetch('api.php', { method: 'POST', body: formData });
        const data = await response.json();
        
        if (data.success) {
            this.reset();
        }
        showToast(data.message, data.success ? 'success' : 'error');
    } catch (error) {
        showToast('خطا در تغییر رمز عبور', 'error');
    }
});

// حذف دستگاه
async function removeDevice(deviceId) {
    if (!confirm('آیا از حذف این دستگاه اطمینان دارید؟')) return;
    
    try {
        const response = await fetch('api.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ action: 'remove_device', device_id: deviceId })
        });
        const data = await response.json();
        
        if (data.success) {
            showToast('دستگاه حذف شد', 'success');
            loadDevices();
        } else {
            showToast(data.message, 'error');
        }
    } catch (error) {
        showToast('خطا در حذف دستگاه', 'error');
    }
}

document.addEventListener('DOMContentLoaded', loadDevices);
</script>