<?php
/**
 * صفحه نوتیفیکیشن‌های کاربر
 */
function renderUserNotifications() {
    global $user;
?>
<main class="pb-20 lg:pb-8 pt-16 min-h-screen">
    <div class="p-4 lg:p-8 max-w-4xl mx-auto">
        <!-- هدر -->
        <div class="flex items-center justify-between mb-6">
            <div>
                <h1 class="text-2xl font-bold">اعلان‌ها</h1>
                <p class="text-gray-400 mt-1">پیام‌ها و اطلاع‌رسانی‌های سیستم</p>
            </div>
            <button onclick="markAllNotificationsRead()" class="glass rounded-xl px-4 py-2 text-sm hover:bg-white/10 transition-colors">
                خواندن همه
            </button>
        </div>

        <!-- فیلتر -->
        <div class="flex items-center gap-2 mb-6">
            <button onclick="filterNotifications('all')" class="user-notif-filter active px-4 py-2 rounded-xl bg-primary-500 text-white text-sm" data-filter="all">
                همه
            </button>
            <button onclick="filterNotifications('unread')" class="user-notif-filter px-4 py-2 rounded-xl glass hover:bg-white/10 text-sm" data-filter="unread">
                خوانده نشده
            </button>
            <button onclick="filterNotifications('info')" class="user-notif-filter px-4 py-2 rounded-xl glass hover:bg-white/10 text-sm" data-filter="info">
                اطلاع‌رسانی
            </button>
            <button onclick="filterNotifications('success')" class="user-notif-filter px-4 py-2 rounded-xl glass hover:bg-white/10 text-sm" data-filter="success">
                موفقیت
            </button>
        </div>

        <!-- لیست اعلان‌ها -->
        <div id="userNotificationsList" class="space-y-3">
            <!-- اعلان‌ها با AJAX لود می‌شوند -->
        </div>
        
        <div id="noUserNotifications" class="hidden glass rounded-3xl p-12 text-center">
            <svg class="w-20 h-20 mx-auto mb-4 text-gray-400 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
            </svg>
            <h3 class="text-xl font-bold mb-2">اعلانی وجود ندارد</h3>
            <p class="text-gray-400">در حال حاضر پیام جدیدی ندارید</p>
        </div>
        
        <!-- بارگذاری بیشتر -->
        <div id="loadMoreNotifications" class="hidden text-center mt-6">
            <button onclick="loadMoreUserNotifications()" class="glass rounded-xl px-6 py-3 hover:bg-white/10 transition-colors">
                بارگذاری بیشتر
            </button>
        </div>
    </div>
</main>

<?php renderMobileNav(); ?>

<script>
let currentUserNotifFilter = 'all';
let currentUserNotifPage = 1;
let hasMoreNotifications = true;

// لود اعلان‌ها
async function loadUserNotifications(page = 1, append = false) {
    try {
        const response = await fetch(`api.php?action=get_user_notifications&filter=${currentUserNotifFilter}&page=${page}`);
        const data = await response.json();
        
        if (data.success) {
            if (append) {
                appendUserNotifications(data.notifications);
            } else {
                renderUserNotifications(data.notifications);
            }
            
            hasMoreNotifications = data.has_more;
            document.getElementById('loadMoreNotifications').classList.toggle('hidden', !hasMoreNotifications);
        }
    } catch (error) {
        console.error('Error loading notifications:', error);
    }
}

function renderUserNotifications(notifications) {
    const container = document.getElementById('userNotificationsList');
    const noNotifs = document.getElementById('noUserNotifications');
    
    if (notifications.length === 0) {
        container.innerHTML = '';
        noNotifs.classList.remove('hidden');
        return;
    }
    
    noNotifs.classList.add('hidden');
    container.innerHTML = notifications.map(notif => createNotificationHTML(notif)).join('');
}

function appendUserNotifications(notifications) {
    const container = document.getElementById('userNotificationsList');
    container.insertAdjacentHTML('beforeend', notifications.map(notif => createNotificationHTML(notif)).join(''));
}

function createNotificationHTML(notif) {
    return `
        <div class="glass rounded-2xl p-4 ${notif.is_read ? 'opacity-70' : ''} hover:bg-white/5 transition-all cursor-pointer" onclick="openNotification(${notif.id})">
            <div class="flex items-start gap-4">
                <div class="w-12 h-12 rounded-xl ${getNotifBgClass(notif.type)} flex items-center justify-center shrink-0">
                    ${getNotifIcon(notif.type)}
                </div>
                <div class="flex-1 min-w-0">
                    <div class="flex items-center justify-between gap-2">
                        <h4 class="font-medium ${notif.is_read ? '' : 'text-white'}">${notif.title}</h4>
                        ${!notif.is_read ? '<span class="w-2 h-2 rounded-full bg-primary-500 shrink-0"></span>' : ''}
                    </div>
                    <p class="text-sm text-gray-400 mt-1 line-clamp-2">${notif.message}</p>
                    <div class="flex items-center gap-3 mt-2 text-xs text-gray-500">
                        <span>${notif.created_at}</span>
                        ${notif.link ? '<span class="text-primary-400">🔗 دارای لینک</span>' : ''}
                    </div>
                </div>
            </div>
        </div>
    `;
}

// فیلتر
function filterNotifications(filter) {
    currentUserNotifFilter = filter;
    currentUserNotifPage = 1;
    
    document.querySelectorAll('.user-notif-filter').forEach(btn => {
        if (btn.dataset.filter === filter) {
            btn.classList.add('active', 'bg-primary-500', 'text-white');
            btn.classList.remove('glass');
        } else {
            btn.classList.remove('active', 'bg-primary-500', 'text-white');
            btn.classList.add('glass');
        }
    });
    
    loadUserNotifications(1);
}

// بارگذاری بیشتر
function loadMoreUserNotifications() {
    currentUserNotifPage++;
    loadUserNotifications(currentUserNotifPage, true);
}

// باز کردن اعلان
async function openNotification(id) {
    try {
        const response = await fetch(`api.php?action=mark_notification_read&id=${id}`);
        const data = await response.json();
        
        if (data.success && data.notification) {
            const notif = data.notification;
            
            // نمایش در modal یا redirect
            if (notif.link) {
                window.location.href = notif.link;
            } else {
                showToast(notif.title, 'info');
            }
            
            // بروزرسانی UI
            loadUserNotifications(1);
        }
    } catch (error) {
        console.error('Error:', error);
    }
}

// خواندن همه
async function markAllNotificationsRead() {
    try {
        const response = await fetch('api.php?action=mark_all_notifications_read');
        const data = await response.json();
        
        if (data.success) {
            showToast('همه اعلان‌ها خوانده شدند', 'success');
            loadUserNotifications(1);
        }
    } catch (error) {
        showToast('خطا در عملیات', 'error');
    }
}

// توابع کمکی
function getNotifBgClass(type) {
    const classes = {
        'info': 'bg-blue-500/20',
        'success': 'bg-green-500/20',
        'warning': 'bg-yellow-500/20',
        'danger': 'bg-red-500/20'
    };
    return classes[type] || classes['info'];
}

function getNotifIcon(type) {
    const icons = {
        'info': '<svg class="w-6 h-6 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>',
        'success': '<svg class="w-6 h-6 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>',
        'warning': '<svg class="w-6 h-6 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path></svg>',
        'danger': '<svg class="w-6 h-6 text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>'
    };
    return icons[type] || icons['info'];
}

// لود اولیه
document.addEventListener('DOMContentLoaded', () => loadUserNotifications());
</script>
<?php
}
?>