<?php
/**
 * داشبورد کاربر
 */
function renderUserDashboard() {
    global $user;
?>
<main class="pb-20 lg:pb-8 pt-16 min-h-screen">
    <div class="p-4 lg:p-8 max-w-6xl mx-auto">
        <!-- هدر خوش‌آمدگویی -->
        <div class="glass rounded-3xl p-6 mb-6 bg-gradient-to-r from-primary-500/20 to-secondary-500/20">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-2xl font-bold">سلام، <?php echo htmlspecialchars($user['username']); ?> 👋</h1>
                    <p class="text-gray-400 mt-1">به پنل کاربری خوش آمدید</p>
                </div>
                <div class="hidden md:block">
                    <div class="text-left">
                        <div class="text-sm text-gray-400">موجودی کیف پول</div>
                        <div class="text-2xl font-bold text-primary-400"><?php echo number_format($user['balance']); ?> تومان</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- باکس‌های آمار -->
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
            <div class="glass rounded-2xl p-4">
                <div class="flex items-center gap-3">
                    <div class="w-12 h-12 rounded-xl bg-blue-500/20 flex items-center justify-center">
                        <svg class="w-6 h-6 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="text-2xl font-bold" id="userActiveConfigs">0</div>
                        <div class="text-sm text-gray-400">کانفیگ فعال</div>
                    </div>
                </div>
            </div>
            <div class="glass rounded-2xl p-4">
                <div class="flex items-center gap-3">
                    <div class="w-12 h-12 rounded-xl bg-green-500/20 flex items-center justify-center">
                        <svg class="w-6 h-6 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="text-2xl font-bold" id="userDevices">0/2</div>
                        <div class="text-sm text-gray-400">دستگاه متصل</div>
                    </div>
                </div>
            </div>
            <div class="glass rounded-2xl p-4">
                <div class="flex items-center gap-3">
                    <div class="w-12 h-12 rounded-xl bg-yellow-500/20 flex items-center justify-center">
                        <svg class="w-6 h-6 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="text-2xl font-bold" id="userDaysLeft">0</div>
                        <div class="text-sm text-gray-400">روز باقیمانده</div>
                    </div>
                </div>
            </div>
            <div class="glass rounded-2xl p-4 md:hidden">
                <div class="flex items-center gap-3">
                    <div class="w-12 h-12 rounded-xl bg-primary-500/20 flex items-center justify-center">
                        <svg class="w-6 h-6 text-primary-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="text-lg font-bold text-primary-400"><?php echo number_format($user['balance']); ?></div>
                        <div class="text-sm text-gray-400">موجودی (تومان)</div>
                    </div>
                </div>
            </div>
            <div class="glass rounded-2xl p-4 hidden md:block">
                <div class="flex items-center gap-3">
                    <div class="w-12 h-12 rounded-xl bg-purple-500/20 flex items-center justify-center">
                        <svg class="w-6 h-6 text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="text-2xl font-bold" id="userReferrals">0</div>
                        <div class="text-sm text-gray-400">زیرمجموعه</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- باکس رفرال -->
        <div class="glass rounded-3xl p-6 mb-6">
            <div class="flex items-center justify-between mb-4">
                <h3 class="font-bold">دعوت از دوستان</h3>
                <a href="?page=referral" class="text-primary-400 text-sm hover:underline">جزئیات بیشتر</a>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div class="bg-white/5 rounded-xl p-4">
                    <div class="text-sm text-gray-400 mb-1">کد معرف شما</div>
                    <div class="flex items-center gap-2">
                        <code class="flex-1 bg-black/30 rounded-lg px-3 py-2 font-mono text-primary-400" id="userReferralCode"><?php echo $user['referral_code'] ?? 'ABC123'; ?></code>
                        <button onclick="copyReferralCode()" class="w-10 h-10 rounded-lg bg-primary-500/20 text-primary-400 flex items-center justify-center hover:bg-primary-500/30">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3"></path>
                            </svg>
                        </button>
                    </div>
                </div>
                <div class="bg-white/5 rounded-xl p-4">
                    <div class="text-sm text-gray-400 mb-1">تعداد زیرمجموعه</div>
                    <div class="text-2xl font-bold" id="referralCount">0</div>
                </div>
                <div class="bg-white/5 rounded-xl p-4">
                    <div class="text-sm text-gray-400 mb-1">پاداش کسب شده</div>
                    <div class="text-2xl font-bold text-green-400"><span id="referralReward">0</span> تومان</div>
                </div>
            </div>
        </div>

        <!-- کانفیگ‌های فعال -->
        <div class="glass rounded-3xl p-6 mb-6">
            <div class="flex items-center justify-between mb-4">
                <h3 class="font-bold">کانفیگ‌های فعال</h3>
                <a href="?page=configs" class="text-primary-400 text-sm hover:underline">مشاهده همه</a>
            </div>
            
            <!-- تب‌های لوکیشن -->
            <div class="flex items-center gap-2 mb-4 overflow-x-auto pb-2">
                <button onclick="filterUserConfigs('all')" class="user-config-tab active px-4 py-2 rounded-xl bg-primary-500 text-white text-sm whitespace-nowrap" data-location="all">
                    همه
                </button>
                <button onclick="filterUserConfigs('germany')" class="user-config-tab px-4 py-2 rounded-xl glass hover:bg-white/10 text-sm whitespace-nowrap" data-location="germany">
                    🇩🇪 آلمان
                </button>
                <button onclick="filterUserConfigs('netherlands')" class="user-config-tab px-4 py-2 rounded-xl glass hover:bg-white/10 text-sm whitespace-nowrap" data-location="netherlands">
                    🇳🇱 هلند
                </button>
                <button onclick="filterUserConfigs('usa')" class="user-config-tab px-4 py-2 rounded-xl glass hover:bg-white/10 text-sm whitespace-nowrap" data-location="usa">
                    🇺🇸 آمریکا
                </button>
            </div>
            
            <div id="userConfigsList" class="space-y-3">
                <!-- کانفیگ‌ها با AJAX لود می‌شوند -->
            </div>
            
            <div id="noConfigsMessage" class="hidden text-center py-8 text-gray-400">
                <svg class="w-16 h-16 mx-auto mb-4 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1"></path>
                </svg>
                <p>کانفیگ فعالی ندارید</p>
                <a href="?page=shop" class="inline-block mt-4 px-6 py-2 rounded-xl bg-primary-500 text-white font-medium">خرید کانفیگ</a>
            </div>
        </div>

        <!-- دکمه‌های سریع -->
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
            <a href="?page=shop" class="glass rounded-2xl p-4 hover:bg-primary-500/20 border border-transparent hover:border-primary-500/50 transition-all text-center">
                <div class="w-12 h-12 rounded-xl bg-primary-500/20 flex items-center justify-center mx-auto mb-3">
                    <svg class="w-6 h-6 text-primary-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"></path>
                    </svg>
                </div>
                <span class="font-medium">خرید کانفیگ</span>
            </a>
            <a href="?page=wallet" class="glass rounded-2xl p-4 hover:bg-green-500/20 border border-transparent hover:border-green-500/50 transition-all text-center">
                <div class="w-12 h-12 rounded-xl bg-green-500/20 flex items-center justify-center mx-auto mb-3">
                    <svg class="w-6 h-6 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                    </svg>
                </div>
                <span class="font-medium">شارژ کیف پول</span>
            </a>
            <a href="?page=tickets" class="glass rounded-2xl p-4 hover:bg-blue-500/20 border border-transparent hover:border-blue-500/50 transition-all text-center">
                <div class="w-12 h-12 rounded-xl bg-blue-500/20 flex items-center justify-center mx-auto mb-3">
                    <svg class="w-6 h-6 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"></path>
                    </svg>
                </div>
                <span class="font-medium">تیکت پشتیبانی</span>
            </a>
            <a href="?page=tutorials" class="glass rounded-2xl p-4 hover:bg-yellow-500/20 border border-transparent hover:border-yellow-500/50 transition-all text-center">
                <div class="w-12 h-12 rounded-xl bg-yellow-500/20 flex items-center justify-center mx-auto mb-3">
                    <svg class="w-6 h-6 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path>
                    </svg>
                </div>
                <span class="font-medium">آموزش و دانلود</span>
            </a>
        </div>
    </div>
</main>

<!-- منوی پایین موبایل -->
<?php renderMobileNav(); ?>

<script>
// لود داده‌های داشبورد
async function loadDashboardData() {
    try {
        const response = await fetch('api.php?action=user_dashboard');
        const data = await response.json();
        
        if (data.success) {
            document.getElementById('userActiveConfigs').textContent = data.active_configs;
            document.getElementById('userDevices').textContent = `${data.connected_devices}/${data.max_devices}`;
            document.getElementById('userDaysLeft').textContent = data.days_left;
            document.getElementById('userReferrals').textContent = data.referral_count;
            document.getElementById('referralCount').textContent = data.referral_count;
            document.getElementById('referralReward').textContent = numberFormat(data.referral_reward);
            
            renderUserConfigs(data.configs);
        }
    } catch (error) {
        console.error('Error loading dashboard:', error);
    }
}

function renderUserConfigs(configs) {
    const container = document.getElementById('userConfigsList');
    const noConfigs = document.getElementById('noConfigsMessage');
    
    if (configs.length === 0) {
        container.innerHTML = '';
        noConfigs.classList.remove('hidden');
        return;
    }
    
    noConfigs.classList.add('hidden');
    container.innerHTML = configs.map(config => `
        <div class="bg-white/5 rounded-xl p-4 config-item" data-location="${config.location}">
            <div class="flex items-center justify-between">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 rounded-xl bg-gradient-to-r ${getConfigGradient(config.type)} flex items-center justify-center">
                        <span class="text-lg">${getLocationFlag(config.location)}</span>
                    </div>
                    <div>
                        <div class="font-medium">${config.name}</div>
                        <div class="text-sm text-gray-400">${config.type.toUpperCase()} • ${config.days_left} روز باقیمانده</div>
                    </div>
                </div>
                <div class="flex items-center gap-2">
                    <button onclick="copyUserConfig('${config.id}')" class="w-10 h-10 rounded-lg bg-primary-500/20 text-primary-400 flex items-center justify-center hover:bg-primary-500/30" title="کپی">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3"></path>
                        </svg>
                    </button>
                    <button onclick="showConfigQR('${config.id}')" class="w-10 h-10 rounded-lg bg-white/10 flex items-center justify-center hover:bg-white/20" title="QR Code">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v1m6 11h2m-6 0h-2v4m0-11v3m0 0h.01M12 12h4.01M16 20h2M4 12h4m12 0h.01M5 8h2a1 1 0 001-1V5a1 1 0 00-1-1H5a1 1 0 00-1 1v2a1 1 0 001 1zm12 0h2a1 1 0 001-1V5a1 1 0 00-1-1h-2a1 1 0 00-1 1v2a1 1 0 001 1zM5 20h2a1 1 0 001-1v-2a1 1 0 00-1-1H5a1 1 0 00-1 1v2a1 1 0 001 1z"></path>
                        </svg>
                    </button>
                </div>
            </div>
            
            <!-- نوار پیشرفت ترافیک -->
            ${config.traffic_limit ? `
                <div class="mt-3">
                    <div class="flex justify-between text-xs text-gray-400 mb-1">
                        <span>مصرف ترافیک</span>
                        <span>${config.used_traffic} / ${config.traffic_limit} GB</span>
                    </div>
                    <div class="h-2 bg-white/10 rounded-full overflow-hidden">
                        <div class="h-full bg-gradient-to-r from-primary-500 to-secondary-500 rounded-full" style="width: ${(config.used_traffic / config.traffic_limit) * 100}%"></div>
                    </div>
                </div>
            ` : ''}
        </div>
    `).join('');
}

// فیلتر کانفیگ‌ها
function filterUserConfigs(location) {
    document.querySelectorAll('.user-config-tab').forEach(tab => {
        if (tab.dataset.location === location) {
            tab.classList.add('active', 'bg-primary-500', 'text-white');
            tab.classList.remove('glass');
        } else {
            tab.classList.remove('active', 'bg-primary-500', 'text-white');
            tab.classList.add('glass');
        }
    });
    
    document.querySelectorAll('.config-item').forEach(item => {
        if (location === 'all' || item.dataset.location === location) {
            item.style.display = 'block';
        } else {
            item.style.display = 'none';
        }
    });
}

// کپی کد رفرال
function copyReferralCode() {
    const code = document.getElementById('userReferralCode').textContent;
    navigator.clipboard.writeText(code);
    showToast('کد معرف کپی شد', 'success');
}

// کپی کانفیگ
async function copyUserConfig(configId) {
    try {
        const response = await fetch(`api.php?action=get_config_data&id=${configId}`);
        const data = await response.json();
        
        if (data.success) {
            await navigator.clipboard.writeText(data.config_data);
            showToast('کانفیگ کپی شد', 'success');
        }
    } catch (error) {
        showToast('خطا در کپی کانفیگ', 'error');
    }
}

function getConfigGradient(type) {
    const gradients = {
        'vless': 'from-blue-500 to-cyan-500',
        'vmess': 'from-green-500 to-emerald-500',
        'trojan': 'from-purple-500 to-pink-500'
    };
    return gradients[type] || gradients['vless'];
}

function getLocationFlag(location) {
    const flags = {
        'germany': '🇩🇪', 'netherlands': '🇳🇱', 'france': '🇫🇷', 'usa': '🇺🇸',
        'uk': '🇬🇧', 'canada': '🇨🇦', 'singapore': '🇸🇬', 'turkey': '🇹🇷'
    };
    return flags[location] || '🌍';
}

// لود اولیه
document.addEventListener('DOMContentLoaded', loadDashboardData);
</script>
<?php
}

/**
 * منوی پایین موبایل
 */
function renderMobileNav() {
?>
<nav class="fixed bottom-0 left-0 right-0 glass border-t border-white/10 lg:hidden z-40">
    <div class="flex items-center justify-around py-2">
        <a href="?page=dashboard" class="flex flex-col items-center py-2 px-4 text-primary-400">
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
            </svg>
            <span class="text-xs mt-1">خانه</span>
        </a>
        <a href="?page=shop" class="flex flex-col items-center py-2 px-4 text-gray-400 hover:text-white">
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"></path>
            </svg>
            <span class="text-xs mt-1">فروشگاه</span>
        </a>
        <a href="?page=configs" class="flex flex-col items-center py-2 px-4 text-gray-400 hover:text-white">
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1"></path>
            </svg>
            <span class="text-xs mt-1">کانفیگ‌ها</span>
        </a>
        <a href="?page=wallet" class="flex flex-col items-center py-2 px-4 text-gray-400 hover:text-white">
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
            </svg>
            <span class="text-xs mt-1">کیف پول</span>
        </a>
        <a href="?page=profile" class="flex flex-col items-center py-2 px-4 text-gray-400 hover:text-white">
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
            </svg>
            <span class="text-xs mt-1">پروفایل</span>
        </a>
    </div>
</nav>
<?php
}
?>