<?php
/**
 * صفحه کانفیگ‌های فعال کاربر
 */
global $user;
$configs = getUserActiveConfigs($user['id']);
?>
<main class="pb-20 lg:pb-8 pt-16 min-h-screen">
    <div class="p-4 lg:p-8 max-w-4xl mx-auto">
        <!-- هدر -->
        <div class="flex items-center justify-between mb-6">
            <div>
                <h1 class="text-2xl font-bold">کانفیگ‌های من</h1>
                <p class="text-gray-400 mt-1">مدیریت کانفیگ‌های فعال</p>
            </div>
            <a href="?page=shop" class="bg-gradient-to-r from-primary-500 to-secondary-500 rounded-xl px-4 py-2 font-medium hover:opacity-90 transition-opacity flex items-center gap-2">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                خرید جدید
            </a>
        </div>

        <?php if (empty($configs)): ?>
            <!-- حالت خالی -->
            <div class="glass rounded-3xl p-12 text-center">
                <svg class="w-20 h-20 mx-auto mb-4 text-gray-400 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1"></path>
                </svg>
                <h3 class="text-xl font-bold mb-2">کانفیگ فعالی ندارید</h3>
                <p class="text-gray-400 mb-6">برای شروع استفاده، یک کانفیگ خریداری کنید</p>
                <a href="?page=shop" class="inline-block bg-gradient-to-r from-primary-500 to-secondary-500 rounded-xl px-6 py-3 font-medium">
                    مشاهده فروشگاه
                </a>
            </div>
        <?php else: ?>
            <!-- لیست کانفیگ‌ها -->
            <div class="space-y-4">
                <?php foreach ($configs as $config): ?>
                    <div class="glass rounded-2xl overflow-hidden">
                        <!-- هدر کانفیگ -->
                        <div class="bg-gradient-to-r <?php echo getConfigGradient($config['type']); ?> p-4">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center gap-3">
                                    <span class="text-3xl"><?php echo getLocationFlag($config['location']); ?></span>
                                    <div>
                                        <div class="font-bold"><?php echo htmlspecialchars($config['name']); ?></div>
                                        <div class="text-sm opacity-80"><?php echo strtoupper($config['type']); ?> • <?php echo getLocationName($config['location']); ?></div>
                                    </div>
                                </div>
                                <div class="text-left">
                                    <div class="font-bold"><?php echo $config['days_left']; ?> روز</div>
                                    <div class="text-sm opacity-80">باقیمانده</div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- محتوای کانفیگ -->
                        <div class="p-4">
                            <!-- نوار پیشرفت زمان -->
                            <div class="mb-4">
                                <div class="flex justify-between text-sm mb-1">
                                    <span class="text-gray-400">زمان باقیمانده</span>
                                    <span><?php echo $config['days_left']; ?> / <?php echo $config['duration'] ?? 30; ?> روز</span>
                                </div>
                                <div class="h-2 bg-white/10 rounded-full overflow-hidden">
                                    <?php 
                                    $duration = $config['duration'] ?? 30;
                                    $percent = ($config['days_left'] / $duration) * 100;
                                    $barColor = $percent > 50 ? 'from-green-500 to-emerald-500' : ($percent > 20 ? 'from-yellow-500 to-orange-500' : 'from-red-500 to-pink-500');
                                    ?>
                                    <div class="h-full bg-gradient-to-r <?php echo $barColor; ?> rounded-full" style="width: <?php echo $percent; ?>%"></div>
                                </div>
                            </div>
                            
                            <?php if ($config['traffic']): ?>
                                <!-- نوار پیشرفت ترافیک -->
                                <div class="mb-4">
                                    <div class="flex justify-between text-sm mb-1">
                                        <span class="text-gray-400">مصرف ترافیک</span>
                                        <span><?php echo $config['used_traffic']; ?> / <?php echo $config['traffic']; ?> GB</span>
                                    </div>
                                    <div class="h-2 bg-white/10 rounded-full overflow-hidden">
                                        <?php $trafficPercent = min(100, ($config['used_traffic'] / $config['traffic']) * 100); ?>
                                        <div class="h-full bg-gradient-to-r from-blue-500 to-cyan-500 rounded-full" style="width: <?php echo $trafficPercent; ?>%"></div>
                                    </div>
                                </div>
                            <?php endif; ?>
                            
                            <!-- دکمه‌ها -->
                            <div class="flex gap-2">
                                <button onclick="copyConfig(<?php echo $config['id']; ?>)" class="flex-1 glass rounded-xl py-3 font-medium hover:bg-primary-500/20 transition-colors flex items-center justify-center gap-2">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3"></path>
                                    </svg>
                                    کپی کانفیگ
                                </button>
                                <button onclick="showQRCode(<?php echo $config['id']; ?>)" class="glass rounded-xl py-3 px-4 hover:bg-white/10 transition-colors">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v1m6 11h2m-6 0h-2v4m0-11v3m0 0h.01M12 12h4.01M16 20h2M4 12h4m12 0h.01M5 8h2a1 1 0 001-1V5a1 1 0 00-1-1H5a1 1 0 00-1 1v2a1 1 0 001 1zm12 0h2a1 1 0 001-1V5a1 1 0 00-1-1h-2a1 1 0 00-1 1v2a1 1 0 001 1zM5 20h2a1 1 0 001-1v-2a1 1 0 00-1-1H5a1 1 0 00-1 1v2a1 1 0 001 1z"></path>
                                    </svg>
                                </button>
                                <button onclick="shareConfig(<?php echo $config['id']; ?>)" class="glass rounded-xl py-3 px-4 hover:bg-white/10 transition-colors">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.684 13.342C8.886 12.938 9 12.482 9 12c0-.482-.114-.938-.316-1.342m0 2.684a3 3 0 110-2.684m0 2.684l6.632 3.316m-6.632-6l6.632-3.316m0 0a3 3 0 105.367-2.684 3 3 0 00-5.367 2.684zm0 9.316a3 3 0 105.368 2.684 3 3 0 00-5.368-2.684z"></path>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</main>

<!-- Modal QR Code -->
<div id="qrModal" class="fixed inset-0 z-50 hidden items-center justify-center p-4 bg-black/50 backdrop-blur-sm">
    <div class="glass rounded-3xl p-6 w-full max-w-sm animate-scale-in text-center">
        <div class="flex items-center justify-between mb-4">
            <h3 class="text-lg font-bold">اسکن QR Code</h3>
            <button onclick="closeQRModal()" class="w-8 h-8 rounded-full bg-white/10 flex items-center justify-center hover:bg-red-500/20">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>
        <div id="qrCodeContainer" class="bg-white p-4 rounded-xl inline-block">
            <!-- QR Code با جاوااسکریپت ایجاد می‌شود -->
        </div>
        <p class="text-sm text-gray-400 mt-4">این کد را با اپلیکیشن VPN اسکن کنید</p>
    </div>
</div>

<?php renderMobileNav(); ?>

<script src="https://cdn.jsdelivr.net/npm/qrcode-generator@1.4.4/qrcode.min.js"></script>
<script>
async function copyConfig(configId) {
    try {
        const response = await fetch(`api.php?action=get_config_data&id=${configId}`);
        const data = await response.json();
        
        if (data.success) {
            await navigator.clipboard.writeText(data.config_data);
            showToast('کانفیگ کپی شد', 'success');
        } else {
            showToast(data.message, 'error');
        }
    } catch (error) {
        showToast('خطا در کپی کانفیگ', 'error');
    }
}

async function showQRCode(configId) {
    try {
        const response = await fetch(`api.php?action=get_config_data&id=${configId}`);
        const data = await response.json();
        
        if (data.success) {
            const qr = qrcode(0, 'M');
            qr.addData(data.config_data);
            qr.make();
            
            document.getElementById('qrCodeContainer').innerHTML = qr.createImgTag(5);
            document.getElementById('qrModal').classList.remove('hidden');
            document.getElementById('qrModal').classList.add('flex');
        }
    } catch (error) {
        showToast('خطا در ایجاد QR Code', 'error');
    }
}

function closeQRModal() {
    document.getElementById('qrModal').classList.add('hidden');
    document.getElementById('qrModal').classList.remove('flex');
}

async function shareConfig(configId) {
    try {
        const response = await fetch(`api.php?action=get_config_data&id=${configId}`);
        const data = await response.json();
        
        if (data.success && navigator.share) {
            await navigator.share({
                title: 'کانفیگ VPN',
                text: data.config_data
            });
        } else {
            await navigator.clipboard.writeText(data.config_data);
            showToast('کانفیگ کپی شد', 'success');
        }
    } catch (error) {
        console.error('Share error:', error);
    }
}
</script>

<?php
// توابع کمکی
function getConfigGradient($type) {
    $gradients = [
        'vless' => 'from-blue-500 to-cyan-500',
        'vmess' => 'from-green-500 to-emerald-500',
        'trojan' => 'from-purple-500 to-pink-500',
        'shadowsocks' => 'from-yellow-500 to-orange-500',
        'netmod' => 'from-pink-500 to-rose-500'
    ];
    return $gradients[$type] ?? $gradients['vless'];
}

function getLocationFlag($location) {
    $flags = [
        'germany' => '🇩🇪', 'netherlands' => '🇳🇱', 'france' => '🇫🇷', 'usa' => '🇺🇸',
        'uk' => '🇬🇧', 'canada' => '🇨🇦', 'singapore' => '🇸🇬', 'turkey' => '🇹🇷', 'uae' => '🇦🇪'
    ];
    return $flags[$location] ?? '🌍';
}

function getLocationName($location) {
    $names = [
        'germany' => 'آلمان', 'netherlands' => 'هلند', 'france' => 'فرانسه', 'usa' => 'آمریکا',
        'uk' => 'انگلستان', 'canada' => 'کانادا', 'singapore' => 'سنگاپور', 'turkey' => 'ترکیه', 'uae' => 'امارات'
    ];
    return $names[$location] ?? $location;
}
?>