<?php
// =====================================================
// pages/auth.php - صفحات احراز هویت
// =====================================================

$error = '';
$success = '';

// پردازش ورود
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login'])) {
    $username = sanitize($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    
    $stmt = db()->prepare("SELECT * FROM users WHERE username = ? OR email = ?");
    $stmt->execute([$username, $username]);
    $user = $stmt->fetch();
    
    if ($user && password_verify($password, $user['password'])) {
        if ($user['is_blocked']) {
            $error = 'حساب کاربری شما مسدود شده است';
        } else {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['is_admin'] = $user['is_admin'];
            
            // بروزرسانی آخرین ورود
            $stmt = db()->prepare("UPDATE users SET last_login = datetime('now') WHERE id = ?");
            $stmt->execute([$user['id']]);
            
            redirect($user['is_admin'] ? '?page=admin' : '?page=dashboard');
        }
    } else {
        $error = 'نام کاربری یا رمز عبور اشتباه است';
    }
}

// پردازش ثبت‌نام
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['register'])) {
    $username = sanitize($_POST['username'] ?? '');
    $email = sanitize($_POST['email'] ?? '');
    $phone = sanitize($_POST['phone'] ?? '');
    $password = $_POST['password'] ?? '';
    $referralCode = sanitize($_POST['referral_code'] ?? '');
    
    // اعتبارسنجی
    if (strlen($username) < 3) {
        $error = 'نام کاربری باید حداقل 3 کاراکتر باشد';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = 'ایمیل نامعتبر است';
    } elseif (strlen($password) < 6) {
        $error = 'رمز عبور باید حداقل 6 کاراکتر باشد';
    } else {
        // بررسی تکراری نبودن
        $stmt = db()->prepare("SELECT id FROM users WHERE username = ? OR email = ?");
        $stmt->execute([$username, $email]);
        if ($stmt->fetch()) {
            $error = 'این نام کاربری یا ایمیل قبلاً ثبت شده است';
        } else {
            // بررسی کد معرف
            $referredBy = null;
            if ($referralCode) {
                $stmt = db()->prepare("SELECT id FROM users WHERE referral_code = ?");
                $stmt->execute([$referralCode]);
                $referrer = $stmt->fetch();
                if ($referrer) {
                    $referredBy = $referrer['id'];
                }
            }
            
            // ثبت کاربر
            $newReferralCode = generateReferralCode();
            $bonus = getSetting('registration_bonus_enabled') ? (float)getSetting('registration_bonus', 0) : 0;
            
            $stmt = db()->prepare("INSERT INTO users (username, email, phone, password, referral_code, referred_by, balance) VALUES (?, ?, ?, ?, ?, ?, ?)");
            $stmt->execute([$username, $email, $phone, password_hash($password, PASSWORD_DEFAULT), $newReferralCode, $referredBy, $bonus]);
            
            $newUserId = db()->lastInsertId();
            
            // ثبت تراکنش بونوس
            if ($bonus > 0) {
                addWalletTransaction($newUserId, $bonus, 'bonus', 'بونوس ثبت‌نام');
                addNotification($newUserId, 'خوش آمدید! 🎉', "شما {$bonus} تومان بونوس ثبت‌نام دریافت کردید", 'success');
            }
            
            $success = 'ثبت‌نام با موفقیت انجام شد. اکنون وارد شوید';
            $page = 'login';
        }
    }
}
?>

<div class="min-h-screen flex items-center justify-center p-4 bg-gradient-to-br from-gray-900 via-purple-900 to-gray-900">
    <!-- Animated Background -->
    <div class="fixed inset-0 overflow-hidden pointer-events-none">
        <div class="absolute -top-40 -right-40 w-80 h-80 bg-purple-500 rounded-full mix-blend-multiply filter blur-3xl opacity-20 animate-blob"></div>
        <div class="absolute -bottom-40 -left-40 w-80 h-80 bg-indigo-500 rounded-full mix-blend-multiply filter blur-3xl opacity-20 animate-blob animation-delay-2000"></div>
        <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-80 h-80 bg-pink-500 rounded-full mix-blend-multiply filter blur-3xl opacity-20 animate-blob animation-delay-4000"></div>
    </div>
    
    <div class="w-full max-w-md relative z-10">
        <!-- Logo & Title -->
        <div class="text-center mb-8 animate__animated animate__fadeInDown">
            <div class="inline-flex items-center justify-center w-20 h-20 rounded-2xl bg-gradient-to-br from-primary to-secondary mb-4 pulse-glow">
                <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                </svg>
            </div>
            <h1 class="text-3xl font-bold gradient-text"><?= getSetting('site_name', 'VPN Store') ?></h1>
            <p class="text-gray-400 mt-2"><?= getSetting('site_description', 'فروشگاه کانفیگ VPN') ?></p>
        </div>
        
        <!-- Auth Card -->
        <div class="glass rounded-3xl p-8 animate__animated animate__fadeInUp" x-data="{ activeTab: '<?= $page === 'register' ? 'register' : 'login' ?>' }">
            <!-- Tabs -->
            <div class="flex gap-2 mb-8 bg-gray-800/50 rounded-2xl p-1">
                <button @click="activeTab = 'login'" 
                        :class="activeTab === 'login' ? 'bg-gradient-to-r from-primary to-secondary text-white' : 'text-gray-400 hover:text-white'"
                        class="flex-1 py-3 rounded-xl font-medium transition-all duration-300">
                    ورود
                </button>
                <button @click="activeTab = 'register'" 
                        :class="activeTab === 'register' ? 'bg-gradient-to-r from-primary to-secondary text-white' : 'text-gray-400 hover:text-white'"
                        class="flex-1 py-3 rounded-xl font-medium transition-all duration-300">
                    ثبت‌نام
                </button>
            </div>
            
            <?php if ($error): ?>
            <div class="mb-6 p-4 bg-red-500/20 border border-red-500/50 rounded-xl text-red-400 text-sm flex items-center gap-3">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <?= $error ?>
            </div>
            <?php endif; ?>
            
            <?php if ($success): ?>
            <div class="mb-6 p-4 bg-green-500/20 border border-green-500/50 rounded-xl text-green-400 text-sm flex items-center gap-3">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <?= $success ?>
            </div>
            <?php endif; ?>
            
            <!-- Login Form -->
            <form x-show="activeTab === 'login'" method="POST" class="space-y-5" x-transition>
                <div>
                    <label class="block text-sm text-gray-400 mb-2">نام کاربری یا ایمیل</label>
                    <div class="relative">
                        <input type="text" name="username" required
                               class="w-full bg-gray-800/50 border border-gray-700 rounded-xl px-4 py-3 pr-12 focus:border-primary focus:ring-2 focus:ring-primary/20 outline-none transition-all"
                               placeholder="username">
                        <svg class="absolute right-4 top-1/2 -translate-y-1/2 w-5 h-5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                        </svg>
                    </div>
                </div>
                
                <div>
                    <label class="block text-sm text-gray-400 mb-2">رمز عبور</label>
                    <div class="relative" x-data="{ show: false }">
                        <input :type="show ? 'text' : 'password'" name="password" required
                               class="w-full bg-gray-800/50 border border-gray-700 rounded-xl px-4 py-3 pr-12 focus:border-primary focus:ring-2 focus:ring-primary/20 outline-none transition-all"
                               placeholder="••••••••">
                        <svg class="absolute right-4 top-1/2 -translate-y-1/2 w-5 h-5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                        </svg>
                        <button type="button" @click="show = !show" class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-500 hover:text-white">
                            <svg x-show="!show" class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                            </svg>
                            <svg x-show="show" class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21"></path>
                            </svg>
                        </button>
                    </div>
                </div>
                
                <button type="submit" name="login" 
                        class="w-full py-4 bg-gradient-to-r from-primary to-secondary rounded-xl font-bold text-white hover:opacity-90 transition-all duration-300 transform hover:scale-[1.02] active:scale-[0.98]">
                    ورود به حساب
                </button>
            </form>
            
            <!-- Register Form -->
            <form x-show="activeTab === 'register'" method="POST" class="space-y-5" x-transition>
                <div>
                    <label class="block text-sm text-gray-400 mb-2">نام کاربری</label>
                    <div class="relative">
                        <input type="text" name="username" required minlength="3"
                               class="w-full bg-gray-800/50 border border-gray-700 rounded-xl px-4 py-3 pr-12 focus:border-primary focus:ring-2 focus:ring-primary/20 outline-none transition-all"
                               placeholder="username">
                        <svg class="absolute right-4 top-1/2 -translate-y-1/2 w-5 h-5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                        </svg>
                    </div>
                </div>
                
                <div>
                    <label class="block text-sm text-gray-400 mb-2">ایمیل</label>
                    <div class="relative">
                        <input type="email" name="email" required
                               class="w-full bg-gray-800/50 border border-gray-700 rounded-xl px-4 py-3 pr-12 focus:border-primary focus:ring-2 focus:ring-primary/20 outline-none transition-all"
                               placeholder="email@example.com">
                        <svg class="absolute right-4 top-1/2 -translate-y-1/2 w-5 h-5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg>
                    </div>
                </div>
                
                <div>
                    <label class="block text-sm text-gray-400 mb-2">شماره موبایل</label>
                    <div class="relative">
                        <input type="tel" name="phone" 
                               class="w-full bg-gray-800/50 border border-gray-700 rounded-xl px-4 py-3 pr-12 focus:border-primary focus:ring-2 focus:ring-primary/20 outline-none transition-all"
                               placeholder="09123456789">
                        <svg class="absolute right-4 top-1/2 -translate-y-1/2 w-5 h-5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                        </svg>
                    </div>
                </div>
                
                <div>
                    <label class="block text-sm text-gray-400 mb-2">رمز عبور</label>
                    <div class="relative" x-data="{ show: false }">
                        <input :type="show ? 'text' : 'password'" name="password" required minlength="6"
                               class="w-full bg-gray-800/50 border border-gray-700 rounded-xl px-4 py-3 pr-12 focus:border-primary focus:ring-2 focus:ring-primary/20 outline-none transition-all"
                               placeholder="حداقل 6 کاراکتر">
                        <svg class="absolute right-4 top-1/2 -translate-y-1/2 w-5 h-5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                        </svg>
                        <button type="button" @click="show = !show" class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-500 hover:text-white">
                            <svg x-show="!show" class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                            </svg>
                            <svg x-show="show" class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21"></path>
                            </svg>
                        </button>
                    </div>
                </div>
                
                <div>
                    <label class="block text-sm text-gray-400 mb-2">کد معرف (اختیاری)</label>
                    <div class="relative">
                        <input type="text" name="referral_code" 
                               class="w-full bg-gray-800/50 border border-gray-700 rounded-xl px-4 py-3 pr-12 focus:border-primary focus:ring-2 focus:ring-primary/20 outline-none transition-all"
                               placeholder="کد معرف"
                               value="<?= $_GET['ref'] ?? '' ?>">
                        <svg class="absolute right-4 top-1/2 -translate-y-1/2 w-5 h-5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                        </svg>
                    </div>
                </div>
                
                <button type="submit" name="register" 
                        class="w-full py-4 bg-gradient-to-r from-primary to-secondary rounded-xl font-bold text-white hover:opacity-90 transition-all duration-300 transform hover:scale-[1.02] active:scale-[0.98]">
                    ایجاد حساب کاربری
                </button>
            </form>
        </div>
        
        <!-- Footer -->
        <p class="text-center text-gray-500 text-sm mt-8">
            © <?= date('Y') ?> <?= getSetting('site_name', 'VPN Store') ?>. تمامی حقوق محفوظ است.
        </p>
    </div>
</div>

<style>
    @keyframes blob {
        0%, 100% { transform: translate(0, 0) scale(1); }
        25% { transform: translate(20px, -30px) scale(1.1); }
        50% { transform: translate(-20px, 20px) scale(0.9); }
        75% { transform: translate(30px, 30px) scale(1.05); }
    }
    .animate-blob {
        animation: blob 10s infinite;
    }
    .animation-delay-2000 {
        animation-delay: 2s;
    }
    .animation-delay-4000 {
        animation-delay: 4s;
    }
</style>