<?php
/**
 * صفحه مدیریت تیکت‌ها
 */
function renderAdminTickets() {
?>
<main class="pr-0 lg:pr-64 pt-16 min-h-screen">
    <div class="p-4 lg:p-8">
        <!-- هدر صفحه -->
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4 mb-8">
            <div>
                <h1 class="text-2xl font-bold">مدیریت تیکت‌ها</h1>
                <p class="text-gray-400 mt-1">پشتیبانی و پاسخگویی به کاربران</p>
            </div>
        </div>

        <!-- آمار تیکت‌ها -->
        <div class="grid grid-cols-2 md:grid-cols-5 gap-4 mb-6">
            <div class="glass rounded-2xl p-4 text-center">
                <div class="text-3xl font-bold text-primary-400" id="totalTickets">0</div>
                <div class="text-sm text-gray-400">کل تیکت‌ها</div>
            </div>
            <div class="glass rounded-2xl p-4 text-center">
                <div class="text-3xl font-bold text-blue-400" id="openTickets">0</div>
                <div class="text-sm text-gray-400">باز</div>
            </div>
            <div class="glass rounded-2xl p-4 text-center">
                <div class="text-3xl font-bold text-yellow-400" id="waitingTickets">0</div>
                <div class="text-sm text-gray-400">در انتظار پاسخ</div>
            </div>
            <div class="glass rounded-2xl p-4 text-center">
                <div class="text-3xl font-bold text-green-400" id="answeredTickets">0</div>
                <div class="text-sm text-gray-400">پاسخ داده شده</div>
            </div>
            <div class="glass rounded-2xl p-4 text-center">
                <div class="text-3xl font-bold text-gray-400" id="closedTickets">0</div>
                <div class="text-sm text-gray-400">بسته شده</div>
            </div>
        </div>

        <!-- فیلترها -->
        <div class="glass rounded-3xl p-6 mb-6">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <div class="relative">
                    <input type="text" id="searchTickets" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 pr-12 focus:border-primary-500 outline-none" placeholder="جستجو...">
                    <svg class="w-5 h-5 absolute right-4 top-1/2 -translate-y-1/2 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                    </svg>
                </div>
                <select id="ticketStatusFilter" class="bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                    <option value="">همه وضعیت‌ها</option>
                    <option value="open">باز</option>
                    <option value="waiting">در انتظار پاسخ</option>
                    <option value="answered">پاسخ داده شده</option>
                    <option value="closed">بسته شده</option>
                </select>
                <select id="ticketPriorityFilter" class="bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                    <option value="">همه اولویت‌ها</option>
                    <option value="high">بالا</option>
                    <option value="medium">متوسط</option>
                    <option value="low">پایین</option>
                </select>
                <select id="ticketDepartmentFilter" class="bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                    <option value="">همه بخش‌ها</option>
                    <option value="sales">فروش</option>
                    <option value="technical">فنی</option>
                    <option value="financial">مالی</option>
                    <option value="general">عمومی</option>
                </select>
            </div>
        </div>

        <!-- لیست تیکت‌ها -->
        <div class="glass rounded-3xl overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="text-gray-400 text-sm border-b border-white/10">
                            <th class="text-right p-4">شناسه</th>
                            <th class="text-right p-4">کاربر</th>
                            <th class="text-right p-4">موضوع</th>
                            <th class="text-right p-4">بخش</th>
                            <th class="text-right p-4">اولویت</th>
                            <th class="text-right p-4">وضعیت</th>
                            <th class="text-right p-4">آخرین بروزرسانی</th>
                            <th class="text-center p-4">عملیات</th>
                        </tr>
                    </thead>
                    <tbody id="ticketsTable">
                        <!-- داده‌ها با AJAX لود می‌شوند -->
                    </tbody>
                </table>
            </div>
            
            <!-- صفحه‌بندی -->
            <div class="p-4 border-t border-white/10">
                <div class="flex items-center justify-between">
                    <span class="text-gray-400 text-sm" id="ticketsCount">نمایش 0 تیکت</span>
                    <div class="flex items-center gap-2" id="ticketsPagination"></div>
                </div>
            </div>
        </div>
    </div>
</main>

<!-- Modal مشاهده و پاسخ تیکت -->
<div id="ticketViewModal" class="fixed inset-0 z-50 hidden items-center justify-center p-4 bg-black/50 backdrop-blur-sm">
    <div class="glass rounded-3xl w-full max-w-4xl animate-scale-in max-h-[90vh] flex flex-col">
        <!-- هدر -->
        <div class="p-6 border-b border-white/10 flex items-center justify-between">
            <div>
                <h3 class="text-lg font-bold" id="ticketSubject">موضوع تیکت</h3>
                <div class="flex items-center gap-3 mt-1">
                    <span class="text-gray-400 text-sm" id="ticketMeta"></span>
                </div>
            </div>
            <div class="flex items-center gap-2">
                <select id="ticketStatusChange" class="bg-white/5 border border-white/10 rounded-lg px-3 py-1.5 text-sm focus:border-primary-500 outline-none">
                    <option value="open">باز</option>
                    <option value="waiting">در انتظار</option>
                    <option value="answered">پاسخ داده شده</option>
                    <option value="closed">بسته</option>
                </select>
                <button onclick="closeTicketModal()" class="w-8 h-8 rounded-full bg-white/10 flex items-center justify-center hover:bg-red-500/20">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                </button>
            </div>
        </div>
        
        <!-- پیام‌ها -->
        <div class="flex-1 overflow-y-auto p-6 space-y-4" id="ticketMessages">
            <!-- پیام‌ها با AJAX لود می‌شوند -->
        </div>
        
        <!-- فرم پاسخ -->
        <div class="p-6 border-t border-white/10">
            <form id="ticketReplyForm" class="space-y-4">
                <input type="hidden" name="ticket_id" id="replyTicketId">
                <div>
                    <textarea name="message" rows="3" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none resize-none" placeholder="پاسخ خود را بنویسید..." required></textarea>
                </div>
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-4">
                        <label class="flex items-center gap-2 cursor-pointer">
                            <input type="file" name="attachment" class="hidden" accept="image/*,.pdf,.zip">
                            <span class="flex items-center gap-2 text-gray-400 hover:text-white">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"></path>
                                </svg>
                                پیوست
                            </span>
                        </label>
                        <label class="flex items-center gap-2 cursor-pointer">
                            <input type="checkbox" name="close_ticket" class="rounded bg-white/10 border-white/20">
                            <span class="text-sm text-gray-400">بستن تیکت بعد از پاسخ</span>
                        </label>
                    </div>
                    <button type="submit" class="bg-gradient-to-r from-primary-500 to-secondary-500 rounded-xl px-6 py-2.5 font-medium hover:opacity-90 transition-opacity flex items-center gap-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"></path>
                        </svg>
                        ارسال پاسخ
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
let currentTicketPage = 1;
const ticketsPerPage = 20;
let currentTicketId = null;

// لود تیکت‌ها
async function loadTickets(page = 1) {
    currentTicketPage = page;
    const status = document.getElementById('ticketStatusFilter').value;
    const priority = document.getElementById('ticketPriorityFilter').value;
    const department = document.getElementById('ticketDepartmentFilter').value;
    const search = document.getElementById('searchTickets').value;
    
    try {
        const response = await fetch(`api.php?action=admin_get_tickets&page=${page}&limit=${ticketsPerPage}&status=${status}&priority=${priority}&department=${department}&search=${encodeURIComponent(search)}`);
        const data = await response.json();
        
        if (data.success) {
            renderTicketsTable(data.tickets);
            document.getElementById('ticketsCount').textContent = `نمایش ${data.tickets.length} از ${data.total} تیکت`;
            
            // آمار
            document.getElementById('totalTickets').textContent = data.stats.total;
            document.getElementById('openTickets').textContent = data.stats.open;
            document.getElementById('waitingTickets').textContent = data.stats.waiting;
            document.getElementById('answeredTickets').textContent = data.stats.answered;
            document.getElementById('closedTickets').textContent = data.stats.closed;
        }
    } catch (error) {
        console.error('Error loading tickets:', error);
    }
}

function renderTicketsTable(tickets) {
    const tbody = document.getElementById('ticketsTable');
    
    if (tickets.length === 0) {
        tbody.innerHTML = `
            <tr>
                <td colspan="8" class="text-center py-12 text-gray-400">
                    <svg class="w-16 h-16 mx-auto mb-4 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"></path>
                    </svg>
                    تیکتی یافت نشد
                </td>
            </tr>
        `;
        return;
    }
    
    tbody.innerHTML = tickets.map(ticket => `
        <tr class="border-b border-white/5 hover:bg-white/5 cursor-pointer" onclick="viewTicket(${ticket.id})">
            <td class="p-4">
                <span class="text-primary-400 font-mono">#${ticket.id}</span>
            </td>
            <td class="p-4">
                <div class="flex items-center gap-3">
                    <div class="w-8 h-8 rounded-full bg-gradient-to-r from-primary-500 to-secondary-500 flex items-center justify-center text-sm font-bold">
                        ${ticket.username.charAt(0).toUpperCase()}
                    </div>
                    <span>${ticket.username}</span>
                </div>
            </td>
            <td class="p-4">
                <div class="max-w-xs truncate font-medium">${ticket.subject}</div>
            </td>
            <td class="p-4">
                <span class="px-2 py-1 rounded-lg text-xs ${getDepartmentClass(ticket.department)}">
                    ${getDepartmentText(ticket.department)}
                </span>
            </td>
            <td class="p-4">
                <span class="px-2 py-1 rounded-lg text-xs ${getPriorityClass(ticket.priority)}">
                    ${getPriorityText(ticket.priority)}
                </span>
            </td>
            <td class="p-4">
                <span class="px-3 py-1 rounded-full text-xs ${getTicketStatusClass(ticket.status)}">
                    ${getTicketStatusText(ticket.status)}
                </span>
            </td>
            <td class="p-4 text-gray-400 text-sm">${ticket.updated_at}</td>
            <td class="p-4">
                <div class="flex items-center justify-center gap-2">
                    <button onclick="event.stopPropagation(); viewTicket(${ticket.id})" class="w-8 h-8 rounded-lg bg-blue-500/20 text-blue-400 flex items-center justify-center hover:bg-blue-500/30" title="مشاهده">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                        </svg>
                    </button>
                    <button onclick="event.stopPropagation(); closeTicket(${ticket.id})" class="w-8 h-8 rounded-lg bg-gray-500/20 text-gray-400 flex items-center justify-center hover:bg-gray-500/30" title="بستن">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                        </svg>
                    </button>
                </div>
            </td>
        </tr>
    `).join('');
}

// مشاهده تیکت
async function viewTicket(ticketId) {
    currentTicketId = ticketId;
    
    try {
        const response = await fetch(`api.php?action=admin_get_ticket&id=${ticketId}`);
        const data = await response.json();
        
        if (data.success) {
            const ticket = data.ticket;
            document.getElementById('ticketSubject').textContent = ticket.subject;
            document.getElementById('ticketMeta').innerHTML = `
                <span class="px-2 py-1 rounded-lg text-xs ${getPriorityClass(ticket.priority)}">${getPriorityText(ticket.priority)}</span>
                <span class="text-gray-500">•</span>
                <span>${ticket.username}</span>
                <span class="text-gray-500">•</span>
                <span>${ticket.created_at}</span>
            `;
            document.getElementById('ticketStatusChange').value = ticket.status;
            document.getElementById('replyTicketId').value = ticket.id;
            
            // نمایش پیام‌ها
            renderTicketMessages(ticket.messages);
            
            document.getElementById('ticketViewModal').classList.remove('hidden');
            document.getElementById('ticketViewModal').classList.add('flex');
        }
    } catch (error) {
        showToast('خطا در دریافت تیکت', 'error');
    }
}

function renderTicketMessages(messages) {
    const container = document.getElementById('ticketMessages');
    container.innerHTML = messages.map(msg => `
        <div class="flex ${msg.is_admin ? 'justify-start' : 'justify-end'}">
            <div class="max-w-[80%] ${msg.is_admin ? 'bg-primary-500/20 border-primary-500/30' : 'bg-white/10'} rounded-2xl p-4 border border-white/10">
                <div class="flex items-center gap-2 mb-2">
                    <div class="w-8 h-8 rounded-full ${msg.is_admin ? 'bg-primary-500' : 'bg-gray-500'} flex items-center justify-center text-sm font-bold">
                        ${msg.is_admin ? 'A' : 'U'}
                    </div>
                    <div>
                        <div class="font-medium text-sm">${msg.is_admin ? 'پشتیبانی' : msg.username}</div>
                        <div class="text-xs text-gray-400">${msg.created_at}</div>
                    </div>
                </div>
                <div class="text-sm leading-relaxed whitespace-pre-wrap">${msg.message}</div>
                ${msg.attachment ? `
                    <div class="mt-3">
                        <a href="${msg.attachment}" target="_blank" class="flex items-center gap-2 text-primary-400 hover:underline text-sm">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"></path>
                            </svg>
                            مشاهده پیوست
                        </a>
                    </div>
                ` : ''}
            </div>
        </div>
    `).join('');
    
    // اسکرول به آخرین پیام
    container.scrollTop = container.scrollHeight;
}

function closeTicketModal() {
    document.getElementById('ticketViewModal').classList.add('hidden');
    document.getElementById('ticketViewModal').classList.remove('flex');
    currentTicketId = null;
}

// ارسال پاسخ
document.getElementById('ticketReplyForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    formData.append('action', 'admin_reply_ticket');
    
    try {
        const response = await fetch('api.php', { method: 'POST', body: formData });
        const data = await response.json();
        
        if (data.success) {
            showToast('پاسخ ارسال شد', 'success');
            this.reset();
            document.getElementById('replyTicketId').value = currentTicketId;
            viewTicket(currentTicketId);
            loadTickets(currentTicketPage);
        } else {
            showToast(data.message, 'error');
        }
    } catch (error) {
        showToast('خطا در ارسال پاسخ', 'error');
    }
});

// تغییر وضعیت تیکت
document.getElementById('ticketStatusChange')?.addEventListener('change', async function() {
    if (!currentTicketId) return;
    
    try {
        const response = await fetch('api.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({
                action: 'admin_update_ticket_status',
                ticket_id: currentTicketId,
                status: this.value
            })
        });
        const data = await response.json();
        
        if (data.success) {
            showToast('وضعیت تیکت بروزرسانی شد', 'success');
            loadTickets(currentTicketPage);
        }
    } catch (error) {
        showToast('خطا در بروزرسانی وضعیت', 'error');
    }
});

// بستن تیکت
async function closeTicket(ticketId) {
    if (!confirm('آیا از بستن این تیکت اطمینان دارید؟')) return;
    
    try {
        const response = await fetch('api.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ action: 'admin_close_ticket', ticket_id: ticketId })
        });
        const data = await response.json();
        
        if (data.success) {
            showToast('تیکت بسته شد', 'success');
            loadTickets(currentTicketPage);
        }
    } catch (error) {
        showToast('خطا در بستن تیکت', 'error');
    }
}

// توابع کمکی
function getDepartmentClass(dept) {
    const classes = {
        'sales': 'bg-green-500/20 text-green-400',
        'technical': 'bg-blue-500/20 text-blue-400',
        'financial': 'bg-yellow-500/20 text-yellow-400',
        'general': 'bg-gray-500/20 text-gray-400'
    };
    return classes[dept] || classes['general'];
}

function getDepartmentText(dept) {
    const texts = { 'sales': 'فروش', 'technical': 'فنی', 'financial': 'مالی', 'general': 'عمومی' };
    return texts[dept] || dept;
}

function getPriorityClass(priority) {
    const classes = {
        'high': 'bg-red-500/20 text-red-400',
        'medium': 'bg-yellow-500/20 text-yellow-400',
        'low': 'bg-green-500/20 text-green-400'
    };
    return classes[priority] || classes['medium'];
}

function getPriorityText(priority) {
    const texts = { 'high': 'بالا', 'medium': 'متوسط', 'low': 'پایین' };
    return texts[priority] || priority;
}

function getTicketStatusClass(status) {
    const classes = {
        'open': 'bg-blue-500/20 text-blue-400',
        'waiting': 'bg-yellow-500/20 text-yellow-400',
        'answered': 'bg-green-500/20 text-green-400',
        'closed': 'bg-gray-500/20 text-gray-400'
    };
    return classes[status] || classes['open'];
}

function getTicketStatusText(status) {
    const texts = { 'open': 'باز', 'waiting': 'در انتظار', 'answered': 'پاسخ داده شده', 'closed': 'بسته' };
    return texts[status] || status;
}

// Event Listeners
document.getElementById('ticketStatusFilter')?.addEventListener('change', () => loadTickets(1));
document.getElementById('ticketPriorityFilter')?.addEventListener('change', () => loadTickets(1));
document.getElementById('ticketDepartmentFilter')?.addEventListener('change', () => loadTickets(1));
document.getElementById('searchTickets')?.addEventListener('input', debounce(() => loadTickets(1), 500));

// لود اولیه
document.addEventListener('DOMContentLoaded', () => loadTickets());
</script>
<?php
}
?>