<?php
/**
 * صفحه تنظیمات سایت
 */
function renderAdminSettings() {
?>
<main class="pr-0 lg:pr-64 pt-16 min-h-screen">
    <div class="p-4 lg:p-8">
        <!-- هدر صفحه -->
        <div class="mb-8">
            <h1 class="text-2xl font-bold">تنظیمات سایت</h1>
            <p class="text-gray-400 mt-1">پیکربندی و تنظیمات عمومی سایت</p>
        </div>

        <!-- تب‌های تنظیمات -->
        <div class="flex items-center gap-2 mb-6 overflow-x-auto pb-2">
            <button onclick="showSettingsTab('general')" class="settings-tab active px-6 py-2.5 rounded-xl bg-primary-500 text-white font-medium whitespace-nowrap" data-tab="general">
                عمومی
            </button>
            <button onclick="showSettingsTab('payment')" class="settings-tab px-6 py-2.5 rounded-xl glass hover:bg-white/10 font-medium whitespace-nowrap" data-tab="payment">
                پرداخت
            </button>
            <button onclick="showSettingsTab('referral')" class="settings-tab px-6 py-2.5 rounded-xl glass hover:bg-white/10 font-medium whitespace-nowrap" data-tab="referral">
                رفرال
            </button>
            <button onclick="showSettingsTab('appearance')" class="settings-tab px-6 py-2.5 rounded-xl glass hover:bg-white/10 font-medium whitespace-nowrap" data-tab="appearance">
                ظاهر
            </button>
            <button onclick="showSettingsTab('security')" class="settings-tab px-6 py-2.5 rounded-xl glass hover:bg-white/10 font-medium whitespace-nowrap" data-tab="security">
                امنیت
            </button>
            <button onclick="showSettingsTab('notifications')" class="settings-tab px-6 py-2.5 rounded-xl glass hover:bg-white/10 font-medium whitespace-nowrap" data-tab="notifications">
                اعلان‌ها
            </button>
        </div>

        <!-- تنظیمات عمومی -->
        <div id="settingsGeneral" class="settings-content">
            <form id="generalSettingsForm" class="space-y-6">
                <div class="glass rounded-3xl p-6">
                    <h3 class="text-lg font-bold mb-4">اطلاعات سایت</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">نام سایت</label>
                            <input type="text" name="site_name" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" value="">
                        </div>
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">آدرس سایت</label>
                            <input type="url" name="site_url" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" value="">
                        </div>
                        <div class="md:col-span-2">
                            <label class="block text-sm text-gray-400 mb-2">توضیحات سایت</label>
                            <textarea name="site_description" rows="3" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none resize-none"></textarea>
                        </div>
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">ایمیل پشتیبانی</label>
                            <input type="email" name="support_email" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                        </div>
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">شماره تماس پشتیبانی</label>
                            <input type="tel" name="support_phone" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                        </div>
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">آیدی تلگرام پشتیبانی</label>
                            <input type="text" name="telegram_support" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" placeholder="@username">
                        </div>
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">کانال تلگرام</label>
                            <input type="text" name="telegram_channel" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" placeholder="@channel">
                        </div>
                    </div>
                </div>

                <div class="glass rounded-3xl p-6">
                    <h3 class="text-lg font-bold mb-4">تنظیمات کاربران</h3>
                    <div class="space-y-4">
                        <label class="flex items-center justify-between p-4 bg-white/5 rounded-xl cursor-pointer">
                            <div>
                                <div class="font-medium">فعال‌سازی ثبت‌نام</div>
                                <div class="text-sm text-gray-400">کاربران جدید می‌توانند ثبت‌نام کنند</div>
                            </div>
                            <input type="checkbox" name="registration_enabled" class="toggle-switch">
                        </label>
                        <label class="flex items-center justify-between p-4 bg-white/5 rounded-xl cursor-pointer">
                            <div>
                                <div class="font-medium">تایید ایمیل</div>
                                <div class="text-sm text-gray-400">کاربران باید ایمیل خود را تایید کنند</div>
                            </div>
                            <input type="checkbox" name="email_verification" class="toggle-switch">
                        </label>
                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm text-gray-400 mb-2">حداکثر دستگاه پیش‌فرض</label>
                                <input type="number" name="default_max_devices" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" value="2" min="1">
                            </div>
                            <div>
                                <label class="block text-sm text-gray-400 mb-2">حداقل شارژ کیف پول (تومان)</label>
                                <input type="number" name="min_wallet_charge" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" value="10000" min="1000">
                            </div>
                        </div>
                    </div>
                </div>

                <button type="submit" class="w-full bg-gradient-to-r from-primary-500 to-secondary-500 rounded-xl py-3 font-medium hover:opacity-90 transition-opacity">
                    ذخیره تنظیمات
                </button>
            </form>
        </div>

        <!-- تنظیمات پرداخت -->
        <div id="settingsPayment" class="settings-content hidden">
            <form id="paymentSettingsForm" class="space-y-6">
                <div class="glass rounded-3xl p-6">
                    <h3 class="text-lg font-bold mb-4">کارت بانکی</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">شماره کارت</label>
                            <input type="text" name="card_number" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none font-mono text-lg tracking-wider" placeholder="0000-0000-0000-0000" maxlength="19">
                        </div>
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">نام صاحب کارت</label>
                            <input type="text" name="card_holder" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                        </div>
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">نام بانک</label>
                            <select name="bank_name" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                                <option value="mellat">بانک ملت</option>
                                <option value="saderat">بانک صادرات</option>
                                <option value="melli">بانک ملی</option>
                                <option value="tejarat">بانک تجارت</option>
                                <option value="parsian">بانک پارسیان</option>
                                <option value="saman">بانک سامان</option>
                                <option value="ayandeh">بانک آینده</option>
                                <option value="shahr">بانک شهر</option>
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">شماره شبا (اختیاری)</label>
                            <input type="text" name="sheba" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none font-mono" placeholder="IR...">
                        </div>
                    </div>
                </div>

                <div class="glass rounded-3xl p-6">
                    <h3 class="text-lg font-bold mb-4">روش‌های پرداخت</h3>
                    <div class="space-y-4">
                        <label class="flex items-center justify-between p-4 bg-white/5 rounded-xl cursor-pointer">
                            <div class="flex items-center gap-3">
                                <div class="w-10 h-10 rounded-xl bg-blue-500/20 flex items-center justify-center">
                                    <svg class="w-5 h-5 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                                    </svg>
                                </div>
                                <div>
                                    <div class="font-medium">کارت به کارت</div>
                                    <div class="text-sm text-gray-400">پرداخت با انتقال وجه</div>
                                </div>
                            </div>
                            <input type="checkbox" name="payment_card" class="toggle-switch" checked>
                        </label>
                        <label class="flex items-center justify-between p-4 bg-white/5 rounded-xl cursor-pointer">
                            <div class="flex items-center gap-3">
                                <div class="w-10 h-10 rounded-xl bg-green-500/20 flex items-center justify-center">
                                    <svg class="w-5 h-5 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                                    </svg>
                                </div>
                                <div>
                                    <div class="font-medium">کیف پول</div>
                                    <div class="text-sm text-gray-400">پرداخت از موجودی کیف پول</div>
                                </div>
                            </div>
                            <input type="checkbox" name="payment_wallet" class="toggle-switch" checked>
                        </label>
                    </div>
                </div>

                <button type="submit" class="w-full bg-gradient-to-r from-primary-500 to-secondary-500 rounded-xl py-3 font-medium hover:opacity-90 transition-opacity">
                    ذخیره تنظیمات
                </button>
            </form>
        </div>

        <!-- تنظیمات رفرال -->
        <div id="settingsReferral" class="settings-content hidden">
            <form id="referralSettingsForm" class="space-y-6">
                <div class="glass rounded-3xl p-6">
                    <h3 class="text-lg font-bold mb-4">سیستم رفرال (زیرمجموعه‌گیری)</h3>
                    <div class="space-y-4">
                        <label class="flex items-center justify-between p-4 bg-white/5 rounded-xl cursor-pointer">
                            <div>
                                <div class="font-medium">فعال‌سازی سیستم رفرال</div>
                                <div class="text-sm text-gray-400">کاربران می‌توانند زیرمجموعه معرفی کنند</div>
                            </div>
                            <input type="checkbox" name="referral_enabled" class="toggle-switch" checked>
                        </label>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm text-gray-400 mb-2">درصد کمیسیون خرید</label>
                                <div class="relative">
                                    <input type="number" name="referral_commission" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" value="10" min="0" max="100">
                                    <span class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400">%</span>
                                </div>
                            </div>
                            <div>
                                <label class="block text-sm text-gray-400 mb-2">بونوس ثبت‌نام (تومان)</label>
                                <input type="number" name="signup_bonus" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" value="5000" min="0">
                            </div>
                        </div>
                        
                        <label class="flex items-center justify-between p-4 bg-white/5 rounded-xl cursor-pointer">
                            <div>
                                <div class="font-medium">بونوس ثبت‌نام با رفرال</div>
                                <div class="text-sm text-gray-400">کاربر جدید نیز بونوس دریافت کند</div>
                            </div>
                            <input type="checkbox" name="referral_signup_bonus" class="toggle-switch">
                        </label>
                        
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">حداقل برداشت کمیسیون (تومان)</label>
                            <input type="number" name="min_withdrawal" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" value="50000" min="0">
                        </div>
                    </div>
                </div>

                <button type="submit" class="w-full bg-gradient-to-r from-primary-500 to-secondary-500 rounded-xl py-3 font-medium hover:opacity-90 transition-opacity">
                    ذخیره تنظیمات
                </button>
            </form>
        </div>

        <!-- تنظیمات ظاهر -->
        <div id="settingsAppearance" class="settings-content hidden">
            <form id="appearanceSettingsForm" class="space-y-6">
                <div class="glass rounded-3xl p-6">
                    <h3 class="text-lg font-bold mb-4">رنگ‌بندی سایت</h3>
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">رنگ اصلی</label>
                            <div class="flex items-center gap-2">
                                <input type="color" name="primary_color" class="w-12 h-12 rounded-xl cursor-pointer bg-transparent border-0" value="#8B5CF6">
                                <input type="text" class="flex-1 bg-white/5 border border-white/10 rounded-xl px-3 py-2 text-sm font-mono" value="#8B5CF6">
                            </div>
                        </div>
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">رنگ ثانویه</label>
                            <div class="flex items-center gap-2">
                                <input type="color" name="secondary_color" class="w-12 h-12 rounded-xl cursor-pointer bg-transparent border-0" value="#EC4899">
                                <input type="text" class="flex-1 bg-white/5 border border-white/10 rounded-xl px-3 py-2 text-sm font-mono" value="#EC4899">
                            </div>
                        </div>
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">رنگ پس‌زمینه</label>
                            <div class="flex items-center gap-2">
                                <input type="color" name="bg_color" class="w-12 h-12 rounded-xl cursor-pointer bg-transparent border-0" value="#0F172A">
                                <input type="text" class="flex-1 bg-white/5 border border-white/10 rounded-xl px-3 py-2 text-sm font-mono" value="#0F172A">
                            </div>
                        </div>
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">رنگ متن</label>
                            <div class="flex items-center gap-2">
                                <input type="color" name="text_color" class="w-12 h-12 rounded-xl cursor-pointer bg-transparent border-0" value="#F8FAFC">
                                <input type="text" class="flex-1 bg-white/5 border border-white/10 rounded-xl px-3 py-2 text-sm font-mono" value="#F8FAFC">
                            </div>
                        </div>
                    </div>
                    
                    <!-- پیش‌نمایش رنگ -->
                    <div class="mt-6 p-4 rounded-xl border border-white/10" id="colorPreview">
                        <div class="text-center text-gray-400 text-sm">پیش‌نمایش رنگ‌بندی</div>
                        <div class="flex items-center justify-center gap-4 mt-4">
                            <button class="px-6 py-2 rounded-xl bg-gradient-to-r from-primary-500 to-secondary-500 font-medium">دکمه نمونه</button>
                            <button class="px-6 py-2 rounded-xl glass font-medium">دکمه ثانویه</button>
                        </div>
                    </div>
                </div>

                <div class="glass rounded-3xl p-6">
                    <h3 class="text-lg font-bold mb-4">لوگو و آیکون</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">لوگو سایت</label>
                            <div class="border-2 border-dashed border-white/20 rounded-xl p-6 text-center hover:border-primary-500/50 transition-colors cursor-pointer" onclick="document.getElementById('logoInput').click()">
                                <input type="file" id="logoInput" name="logo" class="hidden" accept="image/*">
                                <div id="logoPreview" class="mb-3">
                                    <svg class="w-16 h-16 mx-auto text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                    </svg>
                                </div>
                                <p class="text-sm text-gray-400">کلیک کنید یا فایل را بکشید</p>
                                <p class="text-xs text-gray-500 mt-1">PNG, JPG تا 2MB</p>
                            </div>
                        </div>
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">فاویکون</label>
                            <div class="border-2 border-dashed border-white/20 rounded-xl p-6 text-center hover:border-primary-500/50 transition-colors cursor-pointer" onclick="document.getElementById('faviconInput').click()">
                                <input type="file" id="faviconInput" name="favicon" class="hidden" accept="image/*">
                                <div id="faviconPreview" class="mb-3">
                                    <svg class="w-16 h-16 mx-auto text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                    </svg>
                                </div>
                                <p class="text-sm text-gray-400">آیکون سایت (32x32)</p>
                                <p class="text-xs text-gray-500 mt-1">ICO, PNG</p>
                            </div>
                        </div>
                    </div>
                </div>

                <button type="submit" class="w-full bg-gradient-to-r from-primary-500 to-secondary-500 rounded-xl py-3 font-medium hover:opacity-90 transition-opacity">
                    ذخیره تنظیمات
                </button>
            </form>
        </div>

        <!-- تنظیمات امنیت -->
        <div id="settingsSecurity" class="settings-content hidden">
            <form id="securitySettingsForm" class="space-y-6">
                <div class="glass rounded-3xl p-6">
                    <h3 class="text-lg font-bold mb-4">تنظیمات امنیتی</h3>
                    <div class="space-y-4">
                        <label class="flex items-center justify-between p-4 bg-white/5 rounded-xl cursor-pointer">
                            <div>
                                <div class="font-medium">محدودیت تلاش ورود</div>
                                <div class="text-sm text-gray-400">بعد از 5 تلاش ناموفق، 15 دقیقه مسدود شود</div>
                            </div>
                            <input type="checkbox" name="login_limit" class="toggle-switch" checked>
                        </label>
                        <label class="flex items-center justify-between p-4 bg-white/5 rounded-xl cursor-pointer">
                            <div>
                                <div class="font-medium">محدودیت دستگاه</div>
                                <div class="text-sm text-gray-400">هر کانفیگ فقط روی تعداد مشخصی دستگاه کار کند</div>
                            </div>
                            <input type="checkbox" name="device_limit" class="toggle-switch" checked>
                        </label>
                        <label class="flex items-center justify-between p-4 bg-white/5 rounded-xl cursor-pointer">
                            <div>
                                <div class="font-medium">ثبت لاگ ورود</div>
                                <div class="text-sm text-gray-400">ثبت تمام ورود و خروج‌های کاربران</div>
                            </div>
                            <input type="checkbox" name="login_log" class="toggle-switch" checked>
                        </label>
                        <label class="flex items-center justify-between p-4 bg-white/5 rounded-xl cursor-pointer">
                            <div>
                                <div class="font-medium">حالت تعمیرات</div>
                                <div class="text-sm text-gray-400">سایت در حالت تعمیرات قرار گیرد</div>
                            </div>
                            <input type="checkbox" name="maintenance_mode" class="toggle-switch">
                        </label>
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">آدرس‌های IP مجاز پنل مدیریت</label>
                            <textarea name="allowed_ips" rows="3" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none resize-none font-mono text-sm" placeholder="هر IP در یک خط (خالی = همه مجاز)"></textarea>
                        </div>
                    </div>
                </div>

                <div class="glass rounded-3xl p-6">
                    <h3 class="text-lg font-bold mb-4">تغییر رمز عبور ادمین</h3>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">رمز عبور فعلی</label>
                            <input type="password" name="current_password" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                        </div>
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">رمز عبور جدید</label>
                            <input type="password" name="new_password" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                        </div>
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">تکرار رمز عبور</label>
                            <input type="password" name="confirm_password" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                        </div>
                    </div>
                </div>

                <button type="submit" class="w-full bg-gradient-to-r from-primary-500 to-secondary-500 rounded-xl py-3 font-medium hover:opacity-90 transition-opacity">
                    ذخیره تنظیمات
                </button>
            </form>
        </div>

        <!-- تنظیمات اعلان‌ها -->
        <div id="settingsNotifications" class="settings-content hidden">
            <form id="notificationSettingsForm" class="space-y-6">
                <div class="glass rounded-3xl p-6">
                    <h3 class="text-lg font-bold mb-4">اعلان‌های ایمیل</h3>
                    <div class="space-y-4">
                        <label class="flex items-center justify-between p-4 bg-white/5 rounded-xl cursor-pointer">
                            <div>
                                <div class="font-medium">سفارش جدید</div>
                                <div class="text-sm text-gray-400">ارسال ایمیل هنگام ثبت سفارش جدید</div>
                            </div>
                            <input type="checkbox" name="email_new_order" class="toggle-switch" checked>
                        </label>
                        <label class="flex items-center justify-between p-4 bg-white/5 rounded-xl cursor-pointer">
                            <div>
                                <div class="font-medium">تیکت جدید</div>
                                <div class="text-sm text-gray-400">ارسال ایمیل هنگام ثبت تیکت جدید</div>
                            </div>
                            <input type="checkbox" name="email_new_ticket" class="toggle-switch" checked>
                        </label>
                        <label class="flex items-center justify-between p-4 bg-white/5 rounded-xl cursor-pointer">
                            <div>
                                <div class="font-medium">ثبت‌نام کاربر جدید</div>
                                <div class="text-sm text-gray-400">ارسال ایمیل هنگام ثبت‌نام کاربر جدید</div>
                            </div>
                            <input type="checkbox" name="email_new_user" class="toggle-switch">
                        </label>
                        <label class="flex items-center justify-between p-4 bg-white/5 rounded-xl cursor-pointer">
                            <div>
                                <div class="font-medium">انقضای کانفیگ</div>
                                <div class="text-sm text-gray-400">ارسال ایمیل یادآوری قبل از انقضا</div>
                            </div>
                            <input type="checkbox" name="email_expiry_reminder" class="toggle-switch" checked>
                        </label>
                    </div>
                </div>

                <div class="glass rounded-3xl p-6">
                    <h3 class="text-lg font-bold mb-4">تنظیمات SMTP</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">سرور SMTP</label>
                            <input type="text" name="smtp_host" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" placeholder="smtp.gmail.com">
                        </div>
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">پورت</label>
                            <input type="number" name="smtp_port" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" value="587">
                        </div>
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">نام کاربری</label>
                            <input type="text" name="smtp_username" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                        </div>
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">رمز عبور</label>
                            <input type="password" name="smtp_password" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                        </div>
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">ایمیل فرستنده</label>
                            <input type="email" name="smtp_from_email" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                        </div>
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">نام فرستنده</label>
                            <input type="text" name="smtp_from_name" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                        </div>
                    </div>
                    <button type="button" onclick="testEmail()" class="mt-4 px-6 py-2 rounded-xl glass hover:bg-white/10 text-sm">
                        ارسال ایمیل تست
                    </button>
                </div>

                <div class="glass rounded-3xl p-6">
                    <h3 class="text-lg font-bold mb-4">اعلان‌های تلگرام</h3>
                    <div class="space-y-4">
                        <label class="flex items-center justify-between p-4 bg-white/5 rounded-xl cursor-pointer">
                            <div>
                                <div class="font-medium">فعال‌سازی ربات تلگرام</div>
                                <div class="text-sm text-gray-400">ارسال اعلان‌ها به تلگرام</div>
                            </div>
                            <input type="checkbox" name="telegram_enabled" class="toggle-switch">
                        </label>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm text-gray-400 mb-2">توکن ربات</label>
                                <input type="text" name="telegram_bot_token" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none font-mono text-sm" placeholder="123456789:ABC...">
                            </div>
                            <div>
                                <label class="block text-sm text-gray-400 mb-2">Chat ID ادمین</label>
                                <input type="text" name="telegram_admin_chat_id" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none font-mono" placeholder="123456789">
                            </div>
                        </div>
                        <button type="button" onclick="testTelegram()" class="px-6 py-2 rounded-xl glass hover:bg-white/10 text-sm">
                            ارسال پیام تست
                        </button>
                    </div>
                </div>

                <button type="submit" class="w-full bg-gradient-to-r from-primary-500 to-secondary-500 rounded-xl py-3 font-medium hover:opacity-90 transition-opacity">
                    ذخیره تنظیمات
                </button>
            </form>
        </div>
    </div>
</main>

<script>
// نمایش تب تنظیمات
function showSettingsTab(tab) {
    // مخفی کردن همه محتواها
    document.querySelectorAll('.settings-content').forEach(el => el.classList.add('hidden'));
    
    // غیرفعال کردن همه تب‌ها
    document.querySelectorAll('.settings-tab').forEach(el => {
        el.classList.remove('active', 'bg-primary-500', 'text-white');
        el.classList.add('glass');
    });
    
    // نمایش محتوای انتخاب شده
    const contentId = 'settings' + tab.charAt(0).toUpperCase() + tab.slice(1);
    document.getElementById(contentId)?.classList.remove('hidden');
    
    // فعال کردن تب انتخاب شده
    const activeTab = document.querySelector(`.settings-tab[data-tab="${tab}"]`);
    if (activeTab) {
        activeTab.classList.add('active', 'bg-primary-500', 'text-white');
        activeTab.classList.remove('glass');
    }
}

// لود تنظیمات
async function loadSettings() {
    try {
        const response = await fetch('api.php?action=admin_get_settings');
        const data = await response.json();
        
        if (data.success) {
            // پر کردن فرم‌ها با داده‌ها
            Object.keys(data.settings).forEach(key => {
                const input = document.querySelector(`[name="${key}"]`);
                if (input) {
                    if (input.type === 'checkbox') {
                        input.checked = data.settings[key] == 1;
                    } else {
                        input.value = data.settings[key];
                    }
                }
            });
        }
    } catch (error) {
        console.error('Error loading settings:', error);
    }
}

// ذخیره تنظیمات عمومی
document.getElementById('generalSettingsForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    await saveSettings(this, 'general');
});

// ذخیره تنظیمات پرداخت
document.getElementById('paymentSettingsForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    await saveSettings(this, 'payment');
});

// ذخیره تنظیمات رفرال
document.getElementById('referralSettingsForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    await saveSettings(this, 'referral');
});

// ذخیره تنظیمات ظاهر
document.getElementById('appearanceSettingsForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    await saveSettings(this, 'appearance');
});

// ذخیره تنظیمات امنیت
document.getElementById('securitySettingsForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    await saveSettings(this, 'security');
});

// ذخیره تنظیمات اعلان‌ها
document.getElementById('notificationSettingsForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    await saveSettings(this, 'notifications');
});

async function saveSettings(form, type) {
    const formData = new FormData(form);
    formData.append('action', 'admin_save_settings');
    formData.append('settings_type', type);
    
    // تبدیل checkbox ها
    form.querySelectorAll('input[type="checkbox"]').forEach(cb => {
        formData.set(cb.name, cb.checked ? '1' : '0');
    });
    
    try {
        const response = await fetch('api.php', { method: 'POST', body: formData });
        const data = await response.json();
        
        if (data.success) {
            showToast('تنظیمات ذخیره شد', 'success');
        } else {
            showToast(data.message, 'error');
        }
    } catch (error) {
        showToast('خطا در ذخیره تنظیمات', 'error');
    }
}

// تست ایمیل
async function testEmail() {
    try {
        const response = await fetch('api.php?action=admin_test_email');
        const data = await response.json();
        showToast(data.message, data.success ? 'success' : 'error');
    } catch (error) {
        showToast('خطا در ارسال ایمیل تست', 'error');
    }
}

// تست تلگرام
async function testTelegram() {
    try {
        const response = await fetch('api.php?action=admin_test_telegram');
        const data = await response.json();
        showToast(data.message, data.success ? 'success' : 'error');
    } catch (error) {
        showToast('خطا در ارسال پیام تست', 'error');
    }
}

// لود اولیه
document.addEventListener('DOMContentLoaded', loadSettings);
</script>
<?php
}
?>