<?php
/**
 * مدیریت پرداخت‌ها و درخواست‌های شارژ - پنل ادمین
 */
function renderAdminPayments() {
?>
<main class="pr-0 lg:pr-64 pt-16 min-h-screen">
    <div class="p-4 lg:p-8">
        <!-- هدر صفحه -->
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4 mb-8">
            <div>
                <h1 class="text-2xl font-bold">مدیریت پرداخت‌ها</h1>
                <p class="text-gray-400 mt-1">بررسی درخواست‌های شارژ و تراکنش‌ها</p>
            </div>
        </div>

        <!-- آمار -->
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
            <div class="glass rounded-2xl p-4">
                <div class="flex items-center gap-3">
                    <div class="w-12 h-12 rounded-xl bg-yellow-500/20 flex items-center justify-center">
                        <svg class="w-6 h-6 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="text-2xl font-bold text-yellow-400" id="pendingCharges">0</div>
                        <div class="text-sm text-gray-400">در انتظار تایید</div>
                    </div>
                </div>
            </div>
            <div class="glass rounded-2xl p-4">
                <div class="flex items-center gap-3">
                    <div class="w-12 h-12 rounded-xl bg-green-500/20 flex items-center justify-center">
                        <svg class="w-6 h-6 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="text-2xl font-bold text-green-400" id="approvedToday">0</div>
                        <div class="text-sm text-gray-400">تایید امروز</div>
                    </div>
                </div>
            </div>
            <div class="glass rounded-2xl p-4">
                <div class="flex items-center gap-3">
                    <div class="w-12 h-12 rounded-xl bg-blue-500/20 flex items-center justify-center">
                        <svg class="w-6 h-6 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="text-2xl font-bold text-blue-400" id="totalAmountToday">0</div>
                        <div class="text-sm text-gray-400">مبلغ امروز (تومان)</div>
                    </div>
                </div>
            </div>
            <div class="glass rounded-2xl p-4">
                <div class="flex items-center gap-3">
                    <div class="w-12 h-12 rounded-xl bg-purple-500/20 flex items-center justify-center">
                        <svg class="w-6 h-6 text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="text-2xl font-bold text-purple-400" id="totalAmountMonth">0</div>
                        <div class="text-sm text-gray-400">مبلغ ماه (تومان)</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- تب‌ها -->
        <div class="flex items-center gap-2 mb-6">
            <button onclick="showPaymentTab('charges')" class="payment-tab active px-6 py-2.5 rounded-xl bg-primary-500 text-white font-medium" data-tab="charges">
                درخواست‌های شارژ
                <span id="pendingBadge" class="mr-2 px-2 py-0.5 rounded-full bg-white/20 text-xs">0</span>
            </button>
            <button onclick="showPaymentTab('transactions')" class="payment-tab px-6 py-2.5 rounded-xl glass hover:bg-white/10 font-medium" data-tab="transactions">
                تراکنش‌ها
            </button>
            <button onclick="showPaymentTab('withdrawals')" class="payment-tab px-6 py-2.5 rounded-xl glass hover:bg-white/10 font-medium" data-tab="withdrawals">
                درخواست برداشت
            </button>
        </div>

        <!-- محتوای درخواست‌های شارژ -->
        <div id="chargesTab" class="payment-content">
            <div class="glass rounded-3xl overflow-hidden">
                <div class="p-4 border-b border-white/10">
                    <div class="flex flex-col md:flex-row gap-4">
                        <select id="chargeStatusFilter" class="bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                            <option value="pending">در انتظار</option>
                            <option value="approved">تایید شده</option>
                            <option value="rejected">رد شده</option>
                            <option value="">همه</option>
                        </select>
                        <input type="date" id="chargeDateFilter" class="bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                    </div>
                </div>
                
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="text-gray-400 text-sm border-b border-white/10">
                                <th class="text-right p-4">کاربر</th>
                                <th class="text-right p-4">مبلغ</th>
                                <th class="text-right p-4">رسید</th>
                                <th class="text-right p-4">وضعیت</th>
                                <th class="text-right p-4">تاریخ</th>
                                <th class="text-center p-4">عملیات</th>
                            </tr>
                        </thead>
                        <tbody id="chargesTable">
                            <!-- داده‌ها با AJAX لود می‌شوند -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- محتوای تراکنش‌ها -->
        <div id="transactionsTab" class="payment-content hidden">
            <div class="glass rounded-3xl overflow-hidden">
                <div class="p-4 border-b border-white/10">
                    <div class="flex flex-col md:flex-row gap-4">
                        <div class="relative flex-1">
                            <input type="text" id="searchTransactions" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 pr-12 focus:border-primary-500 outline-none" placeholder="جستجو کاربر...">
                            <svg class="w-5 h-5 absolute right-4 top-1/2 -translate-y-1/2 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                            </svg>
                        </div>
                        <select id="transactionTypeFilter" class="bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                            <option value="">همه انواع</option>
                            <option value="charge">شارژ</option>
                            <option value="purchase">خرید</option>
                            <option value="refund">بازگشت</option>
                            <option value="bonus">پاداش</option>
                            <option value="referral">رفرال</option>
                        </select>
                    </div>
                </div>
                
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="text-gray-400 text-sm border-b border-white/10">
                                <th class="text-right p-4">کاربر</th>
                                <th class="text-right p-4">نوع</th>
                                <th class="text-right p-4">مبلغ</th>
                                <th class="text-right p-4">توضیحات</th>
                                <th class="text-right p-4">تاریخ</th>
                            </tr>
                        </thead>
                        <tbody id="transactionsTable">
                            <!-- داده‌ها با AJAX لود می‌شوند -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- محتوای درخواست برداشت -->
        <div id="withdrawalsTab" class="payment-content hidden">
            <div class="glass rounded-3xl overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="text-gray-400 text-sm border-b border-white/10">
                                <th class="text-right p-4">کاربر</th>
                                <th class="text-right p-4">مبلغ</th>
                                <th class="text-right p-4">شماره کارت</th>
                                <th class="text-right p-4">وضعیت</th>
                                <th class="text-right p-4">تاریخ</th>
                                <th class="text-center p-4">عملیات</th>
                            </tr>
                        </thead>
                        <tbody id="withdrawalsTable">
                            <!-- داده‌ها با AJAX لود می‌شوند -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</main>

<!-- Modal تصویر رسید -->
<div id="receiptModal" class="fixed inset-0 z-50 hidden items-center justify-center p-4 bg-black/80" onclick="closeReceiptModal()">
    <div class="max-w-2xl max-h-[90vh] overflow-auto">
        <img id="receiptImage" src="" alt="رسید پرداخت" class="rounded-xl">
    </div>
</div>

<script>
let currentPaymentTab = 'charges';

// نمایش تب
function showPaymentTab(tab) {
    currentPaymentTab = tab;
    
    document.querySelectorAll('.payment-content').forEach(el => el.classList.add('hidden'));
    document.querySelectorAll('.payment-tab').forEach(t => {
        if (t.dataset.tab === tab) {
            t.classList.add('active', 'bg-primary-500', 'text-white');
            t.classList.remove('glass');
        } else {
            t.classList.remove('active', 'bg-primary-500', 'text-white');
            t.classList.add('glass');
        }
    });
    
    document.getElementById(tab + 'Tab')?.classList.remove('hidden');
    
    if (tab === 'charges') loadCharges();
    else if (tab === 'transactions') loadTransactions();
    else if (tab === 'withdrawals') loadWithdrawals();
}

// لود درخواست‌های شارژ
async function loadCharges() {
    const status = document.getElementById('chargeStatusFilter').value;
    const date = document.getElementById('chargeDateFilter').value;
    
    try {
        const response = await fetch(`api.php?action=admin_get_charges&status=${status}&date=${date}`);
        const data = await response.json();
        
        if (data.success) {
            renderChargesTable(data.charges);
            
            // آمار
            document.getElementById('pendingCharges').textContent = data.stats.pending;
            document.getElementById('pendingBadge').textContent = data.stats.pending;
            document.getElementById('approvedToday').textContent = data.stats.approved_today;
            document.getElementById('totalAmountToday').textContent = numberFormat(data.stats.amount_today);
            document.getElementById('totalAmountMonth').textContent = numberFormat(data.stats.amount_month);
        }
    } catch (error) {
        console.error('Error loading charges:', error);
    }
}

function renderChargesTable(charges) {
    const tbody = document.getElementById('chargesTable');
    
    if (charges.length === 0) {
        tbody.innerHTML = `
            <tr>
                <td colspan="6" class="text-center py-12 text-gray-400">درخواستی یافت نشد</td>
            </tr>
        `;
        return;
    }
    
    tbody.innerHTML = charges.map(charge => `
        <tr class="border-b border-white/5 hover:bg-white/5">
            <td class="p-4">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 rounded-xl bg-gradient-to-r from-primary-500 to-secondary-500 flex items-center justify-center font-bold">
                        ${charge.username.charAt(0).toUpperCase()}
                    </div>
                    <div>
                        <div class="font-medium">${charge.username}</div>
                        <div class="text-xs text-gray-400">${charge.phone}</div>
                    </div>
                </div>
            </td>
            <td class="p-4">
                <span class="text-xl font-bold text-green-400">${numberFormat(charge.amount)}</span>
                <span class="text-sm text-gray-400">تومان</span>
            </td>
            <td class="p-4">
                <button onclick="viewReceipt('${charge.receipt_image}')" class="glass rounded-lg px-3 py-1.5 text-sm hover:bg-white/10">
                    مشاهده رسید
                </button>
            </td>
            <td class="p-4">
                <span class="px-3 py-1 rounded-full text-xs ${getChargeStatusClass(charge.status)}">
                    ${getChargeStatusText(charge.status)}
                </span>
            </td>
            <td class="p-4 text-gray-400 text-sm">${charge.created_at}</td>
            <td class="p-4">
                ${charge.status === 'pending' ? `
                    <div class="flex items-center justify-center gap-2">
                        <button onclick="approveCharge(${charge.id})" class="w-10 h-10 rounded-xl bg-green-500/20 text-green-400 flex items-center justify-center hover:bg-green-500/30" title="تایید">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                        </button>
                        <button onclick="rejectCharge(${charge.id})" class="w-10 h-10 rounded-xl bg-red-500/20 text-red-400 flex items-center justify-center hover:bg-red-500/30" title="رد">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                            </svg>
                        </button>
                    </div>
                ` : '-'}
            </td>
        </tr>
    `).join('');
}

// مشاهده رسید
function viewReceipt(imagePath) {
    document.getElementById('receiptImage').src = imagePath;
    document.getElementById('receiptModal').classList.remove('hidden');
    document.getElementById('receiptModal').classList.add('flex');
}

function closeReceiptModal() {
    document.getElementById('receiptModal').classList.add('hidden');
    document.getElementById('receiptModal').classList.remove('flex');
}

// تایید شارژ
async function approveCharge(id) {
    if (!confirm('آیا از تایید این درخواست شارژ اطمینان دارید؟')) return;
    
    try {
        const response = await fetch('api.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ action: 'admin_approve_charge', id: id })
        });
        const data = await response.json();
        
        if (data.success) {
            showToast('شارژ تایید شد و به کیف پول اضافه شد', 'success');
            loadCharges();
        } else {
            showToast(data.message, 'error');
        }
    } catch (error) {
        showToast('خطا در تایید', 'error');
    }
}

// رد شارژ
async function rejectCharge(id) {
    const reason = prompt('دلیل رد درخواست:');
    if (reason === null) return;
    
    try {
        const response = await fetch('api.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ action: 'admin_reject_charge', id: id, reason: reason })
        });
        const data = await response.json();
        
        if (data.success) {
            showToast('درخواست رد شد', 'success');
            loadCharges();
        } else {
            showToast(data.message, 'error');
        }
    } catch (error) {
        showToast('خطا در رد', 'error');
    }
}

// لود تراکنش‌ها
async function loadTransactions() {
    const search = document.getElementById('searchTransactions').value;
    const type = document.getElementById('transactionTypeFilter').value;
    
    try {
        const response = await fetch(`api.php?action=admin_get_all_transactions&search=${encodeURIComponent(search)}&type=${type}`);
        const data = await response.json();
        
        if (data.success) {
            renderTransactionsTable(data.transactions);
        }
    } catch (error) {
        console.error('Error loading transactions:', error);
    }
}

function renderTransactionsTable(transactions) {
    const tbody = document.getElementById('transactionsTable');
    
    tbody.innerHTML = transactions.map(tx => `
        <tr class="border-b border-white/5">
            <td class="p-4">${tx.username}</td>
            <td class="p-4">
                <span class="px-2 py-1 rounded-lg text-xs ${getTransactionTypeClass(tx.type)}">
                    ${getTransactionTypeText(tx.type)}
                </span>
            </td>
            <td class="p-4">
                <span class="font-bold ${tx.amount > 0 ? 'text-green-400' : 'text-red-400'}">
                    ${tx.amount > 0 ? '+' : ''}${numberFormat(tx.amount)} تومان
                </span>
            </td>
            <td class="p-4 text-gray-400 text-sm">${tx.description || '-'}</td>
            <td class="p-4 text-gray-400 text-sm">${tx.created_at}</td>
        </tr>
    `).join('');
}

// لود برداشت‌ها
async function loadWithdrawals() {
    try {
        const response = await fetch('api.php?action=admin_get_withdrawals');
        const data = await response.json();
        
        if (data.success) {
            renderWithdrawalsTable(data.withdrawals);
        }
    } catch (error) {
        console.error('Error loading withdrawals:', error);
    }
}

function renderWithdrawalsTable(withdrawals) {
    const tbody = document.getElementById('withdrawalsTable');
    
    tbody.innerHTML = withdrawals.map(w => `
        <tr class="border-b border-white/5">
            <td class="p-4">${w.username}</td>
            <td class="p-4 font-bold">${numberFormat(w.amount)} تومان</td>
            <td class="p-4 font-mono text-sm">${w.card_number}</td>
            <td class="p-4">
                <span class="px-3 py-1 rounded-full text-xs ${getWithdrawalStatusClass(w.status)}">
                    ${getWithdrawalStatusText(w.status)}
                </span>
            </td>
            <td class="p-4 text-gray-400 text-sm">${w.created_at}</td>
            <td class="p-4">
                ${w.status === 'pending' ? `
                    <div class="flex items-center justify-center gap-2">
                        <button onclick="approveWithdrawal(${w.id})" class="w-8 h-8 rounded-lg bg-green-500/20 text-green-400 flex items-center justify-center hover:bg-green-500/30">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                        </button>
                        <button onclick="rejectWithdrawal(${w.id})" class="w-8 h-8 rounded-lg bg-red-500/20 text-red-400 flex items-center justify-center hover:bg-red-500/30">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                            </svg>
                        </button>
                    </div>
                ` : '-'}
            </td>
        </tr>
    `).join('');
}

// توابع کمکی
function getChargeStatusClass(status) {
    const classes = {
        'pending': 'bg-yellow-500/20 text-yellow-400',
        'approved': 'bg-green-500/20 text-green-400',
        'rejected': 'bg-red-500/20 text-red-400'
    };
    return classes[status] || classes['pending'];
}

function getChargeStatusText(status) {
    const texts = { 'pending': 'در انتظار', 'approved': 'تایید شده', 'rejected': 'رد شده' };
    return texts[status] || status;
}

function getTransactionTypeClass(type) {
    const classes = {
        'charge': 'bg-green-500/20 text-green-400',
        'purchase': 'bg-blue-500/20 text-blue-400',
        'refund': 'bg-yellow-500/20 text-yellow-400',
        'bonus': 'bg-purple-500/20 text-purple-400',
        'referral': 'bg-pink-500/20 text-pink-400'
    };
    return classes[type] || 'bg-gray-500/20 text-gray-400';
}

function getTransactionTypeText(type) {
    const texts = {
        'charge': 'شارژ',
        'purchase': 'خرید',
        'refund': 'بازگشت',
        'bonus': 'پاداش',
        'referral': 'رفرال',
        'withdrawal': 'برداشت'
    };
    return texts[type] || type;
}

function getWithdrawalStatusClass(status) {
    const classes = {
        'pending': 'bg-yellow-500/20 text-yellow-400',
        'approved': 'bg-green-500/20 text-green-400',
        'rejected': 'bg-red-500/20 text-red-400'
    };
    return classes[status] || classes['pending'];
}

function getWithdrawalStatusText(status) {
    const texts = { 'pending': 'در انتظار', 'approved': 'تایید شده', 'rejected': 'رد شده' };
    return texts[status] || status;
}

// Event Listeners
document.getElementById('chargeStatusFilter')?.addEventListener('change', loadCharges);
document.getElementById('chargeDateFilter')?.addEventListener('change', loadCharges);
document.getElementById('searchTransactions')?.addEventListener('input', debounce(loadTransactions, 500));
document.getElementById('transactionTypeFilter')?.addEventListener('change', loadTransactions);

// لود اولیه
document.addEventListener('DOMContentLoaded', loadCharges);
</script>
<?php
}
?>