<?php
/**
 * مدیریت کدهای تخفیف - پنل ادمین
 */
function renderAdminDiscounts() {
?>
<main class="pr-0 lg:pr-64 pt-16 min-h-screen">
    <div class="p-4 lg:p-8">
        <!-- هدر صفحه -->
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4 mb-8">
            <div>
                <h1 class="text-2xl font-bold">کدهای تخفیف</h1>
                <p class="text-gray-400 mt-1">مدیریت و ایجاد کدهای تخفیف</p>
            </div>
            <button onclick="openAddDiscountModal()" class="bg-gradient-to-r from-primary-500 to-secondary-500 rounded-xl px-6 py-2.5 font-medium hover:opacity-90 transition-opacity flex items-center gap-2">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                کد تخفیف جدید
            </button>
        </div>

        <!-- آمار -->
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
            <div class="glass rounded-2xl p-4 text-center">
                <div class="text-3xl font-bold text-blue-400" id="totalDiscounts">0</div>
                <div class="text-sm text-gray-400">کل کدها</div>
            </div>
            <div class="glass rounded-2xl p-4 text-center">
                <div class="text-3xl font-bold text-green-400" id="activeDiscounts">0</div>
                <div class="text-sm text-gray-400">فعال</div>
            </div>
            <div class="glass rounded-2xl p-4 text-center">
                <div class="text-3xl font-bold text-yellow-400" id="usedDiscounts">0</div>
                <div class="text-sm text-gray-400">استفاده شده</div>
            </div>
            <div class="glass rounded-2xl p-4 text-center">
                <div class="text-3xl font-bold text-red-400" id="expiredDiscounts">0</div>
                <div class="text-sm text-gray-400">منقضی</div>
            </div>
        </div>

        <!-- جدول کدهای تخفیف -->
        <div class="glass rounded-3xl overflow-hidden">
            <div class="p-4 border-b border-white/10">
                <div class="flex flex-col md:flex-row gap-4">
                    <div class="relative flex-1">
                        <input type="text" id="searchDiscounts" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 pr-12 focus:border-primary-500 outline-none" placeholder="جستجو کد...">
                        <svg class="w-5 h-5 absolute right-4 top-1/2 -translate-y-1/2 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                        </svg>
                    </div>
                    <select id="discountStatusFilter" class="bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                        <option value="">همه وضعیت‌ها</option>
                        <option value="active">فعال</option>
                        <option value="inactive">غیرفعال</option>
                        <option value="expired">منقضی</option>
                    </select>
                </div>
            </div>
            
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="text-gray-400 text-sm border-b border-white/10">
                            <th class="text-right p-4">کد</th>
                            <th class="text-right p-4">نوع</th>
                            <th class="text-right p-4">مقدار</th>
                            <th class="text-right p-4">استفاده</th>
                            <th class="text-right p-4">انقضا</th>
                            <th class="text-right p-4">وضعیت</th>
                            <th class="text-center p-4">عملیات</th>
                        </tr>
                    </thead>
                    <tbody id="discountsTable">
                        <!-- داده‌ها با AJAX لود می‌شوند -->
                    </tbody>
                </table>
            </div>
            
            <div class="p-4 border-t border-white/10">
                <span class="text-gray-400 text-sm" id="discountsCount">0 کد تخفیف</span>
            </div>
        </div>
    </div>
</main>

<!-- Modal افزودن/ویرایش کد تخفیف -->
<div id="discountModal" class="fixed inset-0 z-50 hidden items-center justify-center p-4 bg-black/50 backdrop-blur-sm">
    <div class="glass rounded-3xl p-6 w-full max-w-lg animate-scale-in max-h-[90vh] overflow-y-auto">
        <div class="flex items-center justify-between mb-6">
            <h3 class="text-lg font-bold" id="discountModalTitle">کد تخفیف جدید</h3>
            <button onclick="closeDiscountModal()" class="w-8 h-8 rounded-full bg-white/10 flex items-center justify-center hover:bg-red-500/20">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>
        
        <form id="discountForm" class="space-y-4">
            <input type="hidden" name="discount_id" id="editDiscountId">
            
            <!-- کد تخفیف -->
            <div>
                <label class="block text-sm text-gray-400 mb-2">کد تخفیف</label>
                <div class="flex gap-2">
                    <input type="text" name="code" id="discountCode" class="flex-1 bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none uppercase font-mono" placeholder="SUMMER2024" required>
                    <button type="button" onclick="generateDiscountCode()" class="px-4 py-3 rounded-xl bg-white/10 hover:bg-white/20 transition-colors" title="تولید خودکار">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                        </svg>
                    </button>
                </div>
            </div>
            
            <!-- نوع تخفیف -->
            <div>
                <label class="block text-sm text-gray-400 mb-2">نوع تخفیف</label>
                <div class="grid grid-cols-2 gap-3">
                    <label class="glass rounded-xl p-4 cursor-pointer border-2 border-transparent has-[:checked]:border-primary-500 text-center">
                        <input type="radio" name="type" value="percent" class="hidden" checked>
                        <div class="text-2xl mb-1">%</div>
                        <div class="font-medium">درصدی</div>
                    </label>
                    <label class="glass rounded-xl p-4 cursor-pointer border-2 border-transparent has-[:checked]:border-primary-500 text-center">
                        <input type="radio" name="type" value="fixed" class="hidden">
                        <div class="text-2xl mb-1">💰</div>
                        <div class="font-medium">مبلغ ثابت</div>
                    </label>
                </div>
            </div>
            
            <!-- مقدار -->
            <div class="grid grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm text-gray-400 mb-2">مقدار تخفیف</label>
                    <input type="number" name="value" id="discountValue" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" placeholder="20" required min="1">
                </div>
                <div>
                    <label class="block text-sm text-gray-400 mb-2">حداکثر تخفیف (تومان)</label>
                    <input type="number" name="max_discount" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" placeholder="50000">
                    <p class="text-xs text-gray-500 mt-1">فقط برای تخفیف درصدی</p>
                </div>
            </div>
            
            <!-- محدودیت‌ها -->
            <div class="grid grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm text-gray-400 mb-2">حداقل مبلغ سفارش</label>
                    <input type="number" name="min_amount" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" placeholder="100000">
                </div>
                <div>
                    <label class="block text-sm text-gray-400 mb-2">حداکثر استفاده</label>
                    <input type="number" name="max_uses" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" placeholder="نامحدود">
                </div>
            </div>
            
            <!-- تاریخ انقضا -->
            <div>
                <label class="block text-sm text-gray-400 mb-2">تاریخ انقضا</label>
                <input type="datetime-local" name="expires_at" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                <p class="text-xs text-gray-500 mt-1">خالی = بدون انقضا</p>
            </div>
            
            <!-- اختصاصی -->
            <div class="grid grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm text-gray-400 mb-2">کاربر خاص (اختیاری)</label>
                    <select name="user_id" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                        <option value="">همه کاربران</option>
                        <!-- کاربران با AJAX لود می‌شوند -->
                    </select>
                </div>
                <div>
                    <label class="block text-sm text-gray-400 mb-2">محصول خاص (اختیاری)</label>
                    <select name="product_id" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                        <option value="">همه محصولات</option>
                        <!-- محصولات با AJAX لود می‌شوند -->
                    </select>
                </div>
            </div>
            
            <!-- وضعیت -->
            <label class="flex items-center gap-3 p-3 bg-white/5 rounded-xl cursor-pointer">
                <input type="checkbox" name="is_active" class="toggle-switch" checked>
                <div>
                    <div class="font-medium">فعال</div>
                    <div class="text-xs text-gray-400">کد تخفیف قابل استفاده باشد</div>
                </div>
            </label>
            
            <div class="flex gap-3 pt-4">
                <button type="submit" class="flex-1 bg-gradient-to-r from-primary-500 to-secondary-500 rounded-xl py-3 font-medium hover:opacity-90 transition-opacity">
                    ذخیره
                </button>
                <button type="button" onclick="closeDiscountModal()" class="flex-1 glass rounded-xl py-3 font-medium hover:bg-white/10">
                    انصراف
                </button>
            </div>
        </form>
    </div>
</div>

<script>
// لود کدهای تخفیف
async function loadDiscounts() {
    const search = document.getElementById('searchDiscounts').value;
    const status = document.getElementById('discountStatusFilter').value;
    
    try {
        const response = await fetch(`api.php?action=admin_get_discounts&search=${encodeURIComponent(search)}&status=${status}`);
        const data = await response.json();
        
        if (data.success) {
            renderDiscountsTable(data.discounts);
            document.getElementById('discountsCount').textContent = `${data.discounts.length} کد تخفیف`;
            
            // آمار
            document.getElementById('totalDiscounts').textContent = data.stats.total;
            document.getElementById('activeDiscounts').textContent = data.stats.active;
            document.getElementById('usedDiscounts').textContent = data.stats.used;
            document.getElementById('expiredDiscounts').textContent = data.stats.expired;
        }
    } catch (error) {
        console.error('Error loading discounts:', error);
    }
}

function renderDiscountsTable(discounts) {
    const tbody = document.getElementById('discountsTable');
    
    if (discounts.length === 0) {
        tbody.innerHTML = `
            <tr>
                <td colspan="7" class="text-center py-12 text-gray-400">
                    کد تخفیفی یافت نشد
                </td>
            </tr>
        `;
        return;
    }
    
    tbody.innerHTML = discounts.map(discount => `
        <tr class="border-b border-white/5 hover:bg-white/5">
            <td class="p-4">
                <code class="px-3 py-1 rounded-lg bg-primary-500/20 text-primary-400 font-mono font-bold">${discount.code}</code>
            </td>
            <td class="p-4">
                <span class="px-2 py-1 rounded-lg text-xs ${discount.type === 'percent' ? 'bg-blue-500/20 text-blue-400' : 'bg-green-500/20 text-green-400'}">
                    ${discount.type === 'percent' ? 'درصدی' : 'مبلغ ثابت'}
                </span>
            </td>
            <td class="p-4 font-bold">
                ${discount.type === 'percent' ? discount.value + '%' : numberFormat(discount.value) + ' تومان'}
            </td>
            <td class="p-4">
                <span class="text-gray-400">${discount.used_count}</span>
                <span class="text-gray-500">/</span>
                <span>${discount.max_uses || '∞'}</span>
            </td>
            <td class="p-4 text-sm text-gray-400">
                ${discount.expires_at || 'بدون انقضا'}
            </td>
            <td class="p-4">
                <span class="px-3 py-1 rounded-full text-xs ${getDiscountStatusClass(discount)}">
                    ${getDiscountStatusText(discount)}
                </span>
            </td>
            <td class="p-4">
                <div class="flex items-center justify-center gap-2">
                    <button onclick="copyDiscountCode('${discount.code}')" class="w-8 h-8 rounded-lg bg-gray-500/20 text-gray-400 flex items-center justify-center hover:bg-gray-500/30" title="کپی">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3"></path>
                        </svg>
                    </button>
                    <button onclick="editDiscount(${discount.id})" class="w-8 h-8 rounded-lg bg-yellow-500/20 text-yellow-400 flex items-center justify-center hover:bg-yellow-500/30" title="ویرایش">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                        </svg>
                    </button>
                    <button onclick="toggleDiscountStatus(${discount.id})" class="w-8 h-8 rounded-lg ${discount.is_active ? 'bg-red-500/20 text-red-400' : 'bg-green-500/20 text-green-400'} flex items-center justify-center hover:opacity-80" title="${discount.is_active ? 'غیرفعال' : 'فعال'}">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            ${discount.is_active ? 
                                '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636"></path>' :
                                '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>'
                            }
                        </svg>
                    </button>
                    <button onclick="deleteDiscount(${discount.id})" class="w-8 h-8 rounded-lg bg-red-500/20 text-red-400 flex items-center justify-center hover:bg-red-500/30" title="حذف">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                        </svg>
                    </button>
                </div>
            </td>
        </tr>
    `).join('');
}

// Modal
function openAddDiscountModal() {
    document.getElementById('discountModalTitle').textContent = 'کد تخفیف جدید';
    document.getElementById('discountForm').reset();
    document.getElementById('editDiscountId').value = '';
    document.getElementById('discountModal').classList.remove('hidden');
    document.getElementById('discountModal').classList.add('flex');
}

function closeDiscountModal() {
    document.getElementById('discountModal').classList.add('hidden');
    document.getElementById('discountModal').classList.remove('flex');
}

// تولید کد
function generateDiscountCode() {
    const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    let code = '';
    for (let i = 0; i < 8; i++) {
        code += chars.charAt(Math.floor(Math.random() * chars.length));
    }
    document.getElementById('discountCode').value = code;
}

// کپی کد
function copyDiscountCode(code) {
    navigator.clipboard.writeText(code);
    showToast('کد کپی شد', 'success');
}

// ویرایش
async function editDiscount(id) {
    try {
        const response = await fetch(`api.php?action=admin_get_discount&id=${id}`);
        const data = await response.json();
        
        if (data.success) {
            const discount = data.discount;
            document.getElementById('discountModalTitle').textContent = 'ویرایش کد تخفیف';
            document.getElementById('editDiscountId').value = discount.id;
            document.getElementById('discountCode').value = discount.code;
            document.getElementById('discountValue').value = discount.value;
            document.querySelector(`input[name="type"][value="${discount.type}"]`).checked = true;
            
            // سایر فیلدها...
            
            document.getElementById('discountModal').classList.remove('hidden');
            document.getElementById('discountModal').classList.add('flex');
        }
    } catch (error) {
        showToast('خطا در دریافت اطلاعات', 'error');
    }
}

// ذخیره
document.getElementById('discountForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    formData.append('action', formData.get('discount_id') ? 'admin_update_discount' : 'admin_add_discount');
    formData.append('is_active', this.querySelector('[name="is_active"]').checked ? '1' : '0');
    
    try {
        const response = await fetch('api.php', { method: 'POST', body: formData });
        const data = await response.json();
        
        if (data.success) {
            showToast(data.message, 'success');
            closeDiscountModal();
            loadDiscounts();
        } else {
            showToast(data.message, 'error');
        }
    } catch (error) {
        showToast('خطا در ذخیره', 'error');
    }
});

// حذف
async function deleteDiscount(id) {
    if (!confirm('آیا از حذف این کد تخفیف اطمینان دارید؟')) return;
    
    try {
        const response = await fetch('api.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ action: 'admin_delete_discount', id: id })
        });
        const data = await response.json();
        
        if (data.success) {
            showToast('کد تخفیف حذف شد', 'success');
            loadDiscounts();
        } else {
            showToast(data.message, 'error');
        }
    } catch (error) {
        showToast('خطا در حذف', 'error');
    }
}

// توابع کمکی
function getDiscountStatusClass(discount) {
    if (!discount.is_active) return 'bg-gray-500/20 text-gray-400';
    if (discount.is_expired) return 'bg-red-500/20 text-red-400';
    if (discount.max_uses && discount.used_count >= discount.max_uses) return 'bg-yellow-500/20 text-yellow-400';
    return 'bg-green-500/20 text-green-400';
}

function getDiscountStatusText(discount) {
    if (!discount.is_active) return 'غیرفعال';
    if (discount.is_expired) return 'منقضی';
    if (discount.max_uses && discount.used_count >= discount.max_uses) return 'تمام شده';
    return 'فعال';
}

// Event Listeners
document.getElementById('searchDiscounts')?.addEventListener('input', debounce(loadDiscounts, 500));
document.getElementById('discountStatusFilter')?.addEventListener('change', loadDiscounts);

// لود اولیه
document.addEventListener('DOMContentLoaded', loadDiscounts);
</script>
<?php
}
?>