<?php
// =====================================================
// pages/admin/dashboard.php - داشبورد مدیریت
// =====================================================

// آمار کلی
$stats = [];

$stmt = db()->query("SELECT COUNT(*) as total FROM users WHERE is_admin = 0");
$stats['users'] = $stmt->fetch()['total'];

$stmt = db()->query("SELECT COUNT(*) as total FROM orders WHERE payment_status = 'completed'");
$stats['orders'] = $stmt->fetch()['total'];

$stmt = db()->query("SELECT SUM(amount) as total FROM payments WHERE status = 'verified'");
$stats['revenue'] = $stmt->fetch()['total'] ?? 0;

$stmt = db()->query("SELECT COUNT(*) as total FROM tickets WHERE status = 'open'");
$stats['tickets'] = $stmt->fetch()['total'];

$stmt = db()->query("SELECT COUNT(*) as total FROM payments WHERE status = 'pending'");
$stats['pendingPayments'] = $stmt->fetch()['total'];

$stmt = db()->query("SELECT COUNT(*) as total FROM configs WHERE is_active = 1");
$stats['configs'] = $stmt->fetch()['total'];

// آخرین سفارشات
$stmt = db()->query("
    SELECT o.*, u.username, c.name as config_name 
    FROM orders o 
    JOIN users u ON o.user_id = u.id 
    JOIN configs c ON o.config_id = c.id 
    ORDER BY o.created_at DESC LIMIT 5
");
$recentOrders = $stmt->fetchAll();

// آخرین کاربران
$stmt = db()->query("SELECT * FROM users WHERE is_admin = 0 ORDER BY created_at DESC LIMIT 5");
$recentUsers = $stmt->fetchAll();
?>

<div class="flex min-h-screen bg-gray-900">
    <!-- Sidebar -->
    <aside :class="sidebarOpen ? 'w-64' : 'w-20'" 
           class="fixed right-0 top-0 h-full glass transition-all duration-300 z-50 hidden lg:block">
        <div class="p-4">
            <!-- Logo -->
            <div class="flex items-center gap-3 mb-8">
                <div class="w-12 h-12 rounded-xl bg-gradient-to-br from-primary to-secondary flex items-center justify-center flex-shrink-0">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                    </svg>
                </div>
                <span x-show="sidebarOpen" class="font-bold text-lg">پنل مدیریت</span>
            </div>
            
            <!-- Menu -->
            <nav class="space-y-2">
                <a href="?page=admin" class="flex items-center gap-3 px-4 py-3 rounded-xl bg-primary/20 text-primary">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z"></path>
                    </svg>
                    <span x-show="sidebarOpen">داشبورد</span>
                </a>
                
                <a href="?page=admin-users" class="flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-gray-800/50 text-gray-400 hover:text-white transition-colors">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
                    </svg>
                    <span x-show="sidebarOpen">کاربران</span>
                </a>
                
                <a href="?page=admin-configs" class="flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-gray-800/50 text-gray-400 hover:text-white transition-colors">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                    </svg>
                    <span x-show="sidebarOpen">کانفیگ‌ها</span>
                </a>
                
                <a href="?page=admin-orders" class="flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-gray-800/50 text-gray-400 hover:text-white transition-colors">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"></path>
                    </svg>
                    <span x-show="sidebarOpen">سفارشات</span>
                </a>
                
                <a href="?page=admin-payments" class="flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-gray-800/50 text-gray-400 hover:text-white transition-colors relative">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                    </svg>
                    <span x-show="sidebarOpen">پرداخت‌ها</span>
                    <?php if ($stats['pendingPayments'] > 0): ?>
                    <span class="absolute left-2 top-1/2 -translate-y-1/2 w-5 h-5 bg-red-500 rounded-full text-xs flex items-center justify-center"><?= $stats['pendingPayments'] ?></span>
                    <?php endif; ?>
                </a>
                
                <a href="?page=admin-tickets" class="flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-gray-800/50 text-gray-400 hover:text-white transition-colors relative">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"></path>
                    </svg>
                    <span x-show="sidebarOpen">تیکت‌ها</span>
                    <?php if ($stats['tickets'] > 0): ?>
                    <span class="absolute left-2 top-1/2 -translate-y-1/2 w-5 h-5 bg-orange-500 rounded-full text-xs flex items-center justify-center"><?= $stats['tickets'] ?></span>
                    <?php endif; ?>
                </a>
                
                <a href="?page=admin-discounts" class="flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-gray-800/50 text-gray-400 hover:text-white transition-colors">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                    </svg>
                    <span x-show="sidebarOpen">کد تخفیف</span>
                </a>
                
                <a href="?page=admin-referrals" class="flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-gray-800/50 text-gray-400 hover:text-white transition-colors">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                    </svg>
                    <span x-show="sidebarOpen">زیرمجموعه‌ها</span>
                </a>
                
                <a href="?page=admin-notifications" class="flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-gray-800/50 text-gray-400 hover:text-white transition-colors">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
                    </svg>
                    <span x-show="sidebarOpen">اعلان‌ها</span>
                </a>
                
                <a href="?page=admin-tutorials" class="flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-gray-800/50 text-gray-400 hover:text-white transition-colors">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path>
                    </svg>
                    <span x-show="sidebarOpen">آموزش‌ها</span>
                </a>
                
                <a href="?page=admin-settings" class="flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-gray-800/50 text-gray-400 hover:text-white transition-colors">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                    </svg>
                    <span x-show="sidebarOpen">تنظیمات</span>
                </a>
                
                <hr class="border-gray-700 my-4">
                
                <a href="?page=dashboard" class="flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-gray-800/50 text-gray-400 hover:text-white transition-colors">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                    </svg>
                    <span x-show="sidebarOpen">پنل کاربری</span>
                </a>
                
                <a href="?page=logout" class="flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-red-500/20 text-red-400 transition-colors">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                    </svg>
                    <span x-show="sidebarOpen">خروج</span>
                </a>
            </nav>
        </div>
        
        <!-- Toggle Button -->
        <button @click="sidebarOpen = !sidebarOpen" 
                class="absolute left-0 top-1/2 -translate-y-1/2 -translate-x-1/2 w-6 h-12 bg-primary rounded-full flex items-center justify-center">
            <svg :class="sidebarOpen ? 'rotate-0' : 'rotate-180'" class="w-4 h-4 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
            </svg>
        </button>
    </aside>
    
    <!-- Mobile Header -->
    <div class="lg:hidden fixed top-0 left-0 right-0 glass z-50">
        <div class="flex items-center justify-between p-4">
            <button @click="mobileMenu = true" class="p-2 rounded-xl bg-gray-800/50">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                </svg>
            </button>
            <h1 class="font-bold">پنل مدیریت</h1>
            <div class="w-10"></div>
        </div>
    </div>
    
    <!-- Mobile Menu Overlay -->
    <div x-show="mobileMenu" x-transition:enter="transition ease-out duration-300"
         x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100"
         x-transition:leave="transition ease-in duration-300"
         x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
         class="lg:hidden fixed inset-0 bg-black/50 z-50" @click="mobileMenu = false"></div>
    
    <!-- Mobile Menu -->
    <div x-show="mobileMenu" x-transition:enter="transition ease-out duration-300"
         x-transition:enter-start="translate-x-full" x-transition:enter-end="translate-x-0"
         x-transition:leave="transition ease-in duration-300"
         x-transition:leave-start="translate-x-0" x-transition:leave-end="translate-x-full"
         class="lg:hidden fixed right-0 top-0 bottom-0 w-72 glass z-50 p-4 overflow-y-auto">
        <div class="flex items-center justify-between mb-6">
            <h2 class="font-bold text-lg">منو</h2>
            <button @click="mobileMenu = false" class="p-2 rounded-xl bg-gray-800/50">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>
        
        <nav class="space-y-2">
            <a href="?page=admin" class="flex items-center gap-3 px-4 py-3 rounded-xl bg-primary/20 text-primary">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6z"></path>
                </svg>
                داشبورد
            </a>
            <a href="?page=admin-users" class="flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-gray-800/50 text-gray-400">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
                </svg>
                کاربران
            </a>
            <a href="?page=admin-configs" class="flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-gray-800/50 text-gray-400">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                </svg>
                کانفیگ‌ها
            </a>
            <a href="?page=admin-orders" class="flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-gray-800/50 text-gray-400">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                </svg>
                سفارشات
            </a>
            <a href="?page=admin-payments" class="flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-gray-800/50 text-gray-400">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                </svg>
                پرداخت‌ها
                <?php if ($stats['pendingPayments'] > 0): ?>
                <span class="mr-auto bg-red-500 px-2 py-0.5 rounded-full text-xs"><?= $stats['pendingPayments'] ?></span>
                <?php endif; ?>
            </a>
            <a href="?page=admin-tickets" class="flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-gray-800/50 text-gray-400">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"></path>
                </svg>
                تیکت‌ها
                <?php if ($stats['tickets'] > 0): ?>
                <span class="mr-auto bg-orange-500 px-2 py-0.5 rounded-full text-xs"><?= $stats['tickets'] ?></span>
                <?php endif; ?>
            </a>
            <a href="?page=admin-settings" class="flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-gray-800/50 text-gray-400">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                </svg>
                تنظیمات
            </a>
        </nav>
    </div>
    
    <!-- Main Content -->
    <main :class="sidebarOpen ? 'lg:mr-64' : 'lg:mr-20'" class="flex-1 p-4 lg:p-8 pt-20 lg:pt-8 transition-all">
        <div class="max-w-7xl mx-auto">
            <!-- Header -->
            <div class="mb-8">
                <h1 class="text-2xl font-bold">داشبورد مدیریت</h1>
                <p class="text-gray-400"><?= jalaliDate() ?></p>
            </div>
            
            <!-- Stats Grid -->
            <div class="grid grid-cols-2 lg:grid-cols-3 xl:grid-cols-6 gap-4 mb-8">
                <div class="glass rounded-2xl p-5 card-hover">
                    <div class="flex items-center justify-between mb-3">
                        <div class="w-12 h-12 rounded-xl bg-blue-500/20 flex items-center justify-center">
                            <svg class="w-6 h-6 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
                            </svg>
                        </div>
                    </div>
                    <p class="text-2xl font-bold"><?= $stats['users'] ?></p>
                    <p class="text-gray-400 text-sm">کاربران</p>
                </div>
                
                <div class="glass rounded-2xl p-5 card-hover">
                    <div class="flex items-center justify-between mb-3">
                        <div class="w-12 h-12 rounded-xl bg-green-500/20 flex items-center justify-center">
                            <svg class="w-6 h-6 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                            </svg>
                        </div>
                    </div>
                    <p class="text-2xl font-bold"><?= $stats['orders'] ?></p>
                    <p class="text-gray-400 text-sm">سفارشات</p>
                </div>
                
                <div class="glass rounded-2xl p-5 card-hover">
                    <div class="flex items-center justify-between mb-3">
                        <div class="w-12 h-12 rounded-xl bg-amber-500/20 flex items-center justify-center">
                            <svg class="w-6 h-6 text-amber-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                    </div>
                    <p class="text-xl font-bold"><?= formatPrice($stats['revenue']) ?></p>
                    <p class="text-gray-400 text-sm">درآمد کل</p>
                </div>
                
                <div class="glass rounded-2xl p-5 card-hover">
                    <div class="flex items-center justify-between mb-3">
                        <div class="w-12 h-12 rounded-xl bg-purple-500/20 flex items-center justify-center">
                            <svg class="w-6 h-6 text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                            </svg>
                        </div>
                    </div>
                    <p class="text-2xl font-bold"><?= $stats['configs'] ?></p>
                    <p class="text-gray-400 text-sm">کانفیگ فعال</p>
                </div>
                
                <div class="glass rounded-2xl p-5 card-hover">
                    <div class="flex items-center justify-between mb-3">
                        <div class="w-12 h-12 rounded-xl bg-red-500/20 flex items-center justify-center">
                            <svg class="w-6 h-6 text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                            </svg>
                        </div>
                    </div>
                    <p class="text-2xl font-bold"><?= $stats['pendingPayments'] ?></p>
                    <p class="text-gray-400 text-sm">در انتظار تأیید</p>
                </div>
                
                <div class="glass rounded-2xl p-5 card-hover">
                    <div class="flex items-center justify-between mb-3">
                        <div class="w-12 h-12 rounded-xl bg-orange-500/20 flex items-center justify-center">
                            <svg class="w-6 h-6 text-orange-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"></path>
                            </svg>
                        </div>
                    </div>
                    <p class="text-2xl font-bold"><?= $stats['tickets'] ?></p>
                    <p class="text-gray-400 text-sm">تیکت باز</p>
                </div>
            </div>
            
            <!-- Quick Actions -->
            <div class="grid md:grid-cols-4 gap-4 mb-8">
                <button onclick="showAddConfigModal()" class="glass rounded-2xl p-4 hover:bg-green-500/20 border border-transparent hover:border-green-500/50 transition-all flex items-center gap-3">
                    <div class="w-10 h-10 rounded-xl bg-green-500/20 flex items-center justify-center">
                        <svg class="w-5 h-5 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                        </svg>
                    </div>
                    <span class="font-medium">افزودن کانفیگ</span>
                </button>
                
                <button onclick="showSendNotificationModal()" class="glass rounded-2xl p-4 hover:bg-blue-500/20 border border-transparent hover:border-blue-500/50 transition-all flex items-center gap-3">
                    <div class="w-10 h-10 rounded-xl bg-blue-500/20 flex items-center justify-center">
                        <svg class="w-5 h-5 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
                        </svg>
                    </div>
                    <span class="font-medium">ارسال اعلان</span>
                </button>
                
                <button onclick="showAddDiscountModal()" class="glass rounded-2xl p-4 hover:bg-purple-500/20 border border-transparent hover:border-purple-500/50 transition-all flex items-center gap-3">
                    <div class="w-10 h-10 rounded-xl bg-purple-500/20 flex items-center justify-center">
                        <svg class="w-5 h-5 text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                        </svg>
                    </div>
                    <span class="font-medium">کد تخفیف</span>
                </button>
                
                <a href="?page=admin-settings" class="glass rounded-2xl p-4 hover:bg-amber-500/20 border border-transparent hover:border-amber-500/50 transition-all flex items-center gap-3">
                    <div class="w-10 h-10 rounded-xl bg-amber-500/20 flex items-center justify-center">
                        <svg class="w-5 h-5 text-amber-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                    </div>
                    <span class="font-medium">تنظیمات سایت</span>
                </a>
            </div>
        </div>

        <!-- آخرین سفارشات -->
        <div class="glass rounded-3xl p-6 mt-6">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-lg font-bold">آخرین سفارشات</h3>
                <a href="?page=admin-orders" class="text-primary-400 text-sm hover:underline">مشاهده همه</a>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="text-gray-400 text-sm border-b border-white/10">
                            <th class="text-right pb-4">کاربر</th>
                            <th class="text-right pb-4">محصول</th>
                            <th class="text-right pb-4">مبلغ</th>
                            <th class="text-right pb-4">وضعیت</th>
                            <th class="text-right pb-4">تاریخ</th>
                            <th class="text-center pb-4">عملیات</th>
                        </tr>
                    </thead>
                    <tbody id="latestOrdersTable">
                        <!-- داده‌ها با AJAX لود می‌شوند -->
                    </tbody>
                </table>
            </div>
        </div>

        <!-- آخرین تیکت‌ها -->
        <div class="glass rounded-3xl p-6 mt-6">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-lg font-bold">آخرین تیکت‌ها</h3>
                <a href="?page=admin-tickets" class="text-primary-400 text-sm hover:underline">مشاهده همه</a>
            </div>
            <div class="space-y-3" id="latestTickets">
                <!-- تیکت‌ها با AJAX لود می‌شوند -->
            </div>
        </div>
    </div>
</main>

<!-- Modal کد تخفیف -->
<div id="discountModal" class="fixed inset-0 z-50 hidden items-center justify-center p-4 bg-black/50 backdrop-blur-sm">
    <div class="glass rounded-3xl p-6 w-full max-w-md animate-scale-in">
        <div class="flex items-center justify-between mb-6">
            <h3 class="text-lg font-bold">افزودن کد تخفیف</h3>
            <button onclick="closeDiscountModal()" class="w-8 h-8 rounded-full bg-white/10 flex items-center justify-center hover:bg-red-500/20">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>
        <form id="discountForm" class="space-y-4">
            <div>
                <label class="block text-sm text-gray-400 mb-2">کد تخفیف</label>
                <input type="text" name="code" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" placeholder="مثال: SUMMER2024" required>
            </div>
            <div>
                <label class="block text-sm text-gray-400 mb-2">نوع تخفیف</label>
                <select name="type" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                    <option value="percent">درصدی</option>
                    <option value="fixed">مبلغ ثابت</option>
                </select>
            </div>
            <div>
                <label class="block text-sm text-gray-400 mb-2">مقدار تخفیف</label>
                <input type="number" name="value" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" placeholder="مثال: 20" required>
            </div>
            <div>
                <label class="block text-sm text-gray-400 mb-2">حداکثر استفاده</label>
                <input type="number" name="max_uses" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" placeholder="خالی = نامحدود">
            </div>
            <div>
                <label class="block text-sm text-gray-400 mb-2">تاریخ انقضا</label>
                <input type="text" name="expires_at" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none persian-date" placeholder="انتخاب تاریخ">
            </div>
            <button type="submit" class="w-full bg-gradient-to-r from-primary-500 to-secondary-500 rounded-xl py-3 font-medium hover:opacity-90 transition-opacity">
                ذخیره کد تخفیف
            </button>
        </form>
    </div>
</div>

<!-- Modal ارسال پیام -->
<div id="notificationModal" class="fixed inset-0 z-50 hidden items-center justify-center p-4 bg-black/50 backdrop-blur-sm">
    <div class="glass rounded-3xl p-6 w-full max-w-md animate-scale-in">
        <div class="flex items-center justify-between mb-6">
            <h3 class="text-lg font-bold">ارسال پیام/نوتیفیکیشن</h3>
            <button onclick="closeNotificationModal()" class="w-8 h-8 rounded-full bg-white/10 flex items-center justify-center hover:bg-red-500/20">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>
        <form id="notificationForm" class="space-y-4">
            <div>
                <label class="block text-sm text-gray-400 mb-2">گیرنده</label>
                <select name="recipient" id="notifRecipient" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                    <option value="all">همه کاربران</option>
                    <option value="specific">کاربر خاص</option>
                </select>
            </div>
            <div id="userSelectBox" class="hidden">
                <label class="block text-sm text-gray-400 mb-2">انتخاب کاربر</label>
                <select name="user_id" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                    <!-- کاربران با AJAX لود می‌شوند -->
                </select>
            </div>
            <div>
                <label class="block text-sm text-gray-400 mb-2">عنوان</label>
                <input type="text" name="title" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" placeholder="عنوان پیام" required>
            </div>
            <div>
                <label class="block text-sm text-gray-400 mb-2">متن پیام</label>
                <textarea name="message" rows="4" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none resize-none" placeholder="متن پیام..." required></textarea>
            </div>
            <div>
                <label class="block text-sm text-gray-400 mb-2">نوع پیام</label>
                <select name="type" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
                    <option value="info">اطلاع‌رسانی</option>
                    <option value="success">موفقیت</option>
                    <option value="warning">هشدار</option>
                    <option value="danger">خطر</option>
                </select>
            </div>
            <button type="submit" class="w-full bg-gradient-to-r from-primary-500 to-secondary-500 rounded-xl py-3 font-medium hover:opacity-90 transition-opacity">
                ارسال پیام
            </button>
        </form>
    </div>
</div>

<script>
// باز کردن Modal کد تخفیف
function openDiscountModal() {
    document.getElementById('discountModal').classList.remove('hidden');
    document.getElementById('discountModal').classList.add('flex');
}

function closeDiscountModal() {
    document.getElementById('discountModal').classList.add('hidden');
    document.getElementById('discountModal').classList.remove('flex');
}

// باز کردن Modal نوتیفیکیشن
function openNotificationModal() {
    document.getElementById('notificationModal').classList.remove('hidden');
    document.getElementById('notificationModal').classList.add('flex');
    loadUsersForNotification();
}

function closeNotificationModal() {
    document.getElementById('notificationModal').classList.add('hidden');
    document.getElementById('notificationModal').classList.remove('flex');
}

// نمایش/مخفی کردن انتخاب کاربر
document.getElementById('notifRecipient')?.addEventListener('change', function() {
    const userBox = document.getElementById('userSelectBox');
    if (this.value === 'specific') {
        userBox.classList.remove('hidden');
    } else {
        userBox.classList.add('hidden');
    }
});

// لود آمار داشبورد
async function loadDashboardStats() {
    try {
        const response = await fetch('api.php?action=admin_dashboard_stats');
        const data = await response.json();
        
        if (data.success) {
            document.getElementById('totalUsers').textContent = data.stats.total_users;
            document.getElementById('activeConfigs').textContent = data.stats.active_configs;
            document.getElementById('todayIncome').textContent = numberFormat(data.stats.today_income) + ' تومان';
            document.getElementById('pendingOrders').textContent = data.stats.pending_orders;
        }
    } catch (error) {
        console.error('Error loading stats:', error);
    }
}

// لود آخرین سفارشات
async function loadLatestOrders() {
    try {
        const response = await fetch('api.php?action=admin_latest_orders&limit=5');
        const data = await response.json();
        
        if (data.success) {
            const tbody = document.getElementById('latestOrdersTable');
            tbody.innerHTML = data.orders.map(order => `
                <tr class="border-b border-white/5 hover:bg-white/5">
                    <td class="py-4">
                        <div class="flex items-center gap-3">
                            <div class="w-8 h-8 rounded-full bg-gradient-to-r from-primary-500 to-secondary-500 flex items-center justify-center text-sm font-bold">
                                ${order.username.charAt(0).toUpperCase()}
                            </div>
                            <span>${order.username}</span>
                        </div>
                    </td>
                    <td class="py-4">${order.product_name}</td>
                    <td class="py-4">${numberFormat(order.amount)} تومان</td>
                    <td class="py-4">
                        <span class="px-3 py-1 rounded-full text-xs ${getStatusClass(order.status)}">
                            ${getStatusText(order.status)}
                        </span>
                    </td>
                    <td class="py-4 text-gray-400">${order.created_at}</td>
                    <td class="py-4 text-center">
                        <div class="flex items-center justify-center gap-2">
                            ${order.status === 'pending' ? `
                                <button onclick="approveOrder(${order.id})" class="w-8 h-8 rounded-lg bg-green-500/20 text-green-400 flex items-center justify-center hover:bg-green-500/30" title="تایید">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                    </svg>
                                </button>
                                <button onclick="rejectOrder(${order.id})" class="w-8 h-8 rounded-lg bg-red-500/20 text-red-400 flex items-center justify-center hover:bg-red-500/30" title="رد">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                    </svg>
                                </button>
                            ` : ''}
                            <button onclick="viewOrder(${order.id})" class="w-8 h-8 rounded-lg bg-blue-500/20 text-blue-400 flex items-center justify-center hover:bg-blue-500/30" title="مشاهده">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                </svg>
                            </button>
                        </div>
                    </td>
                </tr>
            `).join('');
        }
    } catch (error) {
        console.error('Error loading orders:', error);
    }
}

// لود آخرین تیکت‌ها
async function loadLatestTickets() {
    try {
        const response = await fetch('api.php?action=admin_latest_tickets&limit=5');
        const data = await response.json();
        
        if (data.success) {
            const container = document.getElementById('latestTickets');
            container.innerHTML = data.tickets.map(ticket => `
                <a href="?page=admin-ticket-view&id=${ticket.id}" class="block glass rounded-xl p-4 hover:bg-white/10 transition-all">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 rounded-full bg-gradient-to-r ${getPriorityGradient(ticket.priority)} flex items-center justify-center">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-3l-4 4z"></path>
                                </svg>
                            </div>
                            <div>
                                <h4 class="font-medium">${ticket.subject}</h4>
                                <p class="text-sm text-gray-400">${ticket.username} - ${ticket.created_at}</p>
                            </div>
                        </div>
                        <span class="px-3 py-1 rounded-full text-xs ${getTicketStatusClass(ticket.status)}">
                            ${getTicketStatusText(ticket.status)}
                        </span>
                    </div>
                </a>
            `).join('');
        }
    } catch (error) {
        console.error('Error loading tickets:', error);
    }
}

// تایید سفارش
async function approveOrder(orderId) {
    if (!confirm('آیا از تایید این سفارش اطمینان دارید؟')) return;
    
    try {
        const response = await fetch('api.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ action: 'approve_order', order_id: orderId })
        });
        const data = await response.json();
        
        if (data.success) {
            showToast('سفارش با موفقیت تایید شد', 'success');
            loadLatestOrders();
            loadDashboardStats();
        } else {
            showToast(data.message, 'error');
        }
    } catch (error) {
        showToast('خطا در تایید سفارش', 'error');
    }
}

// رد سفارش
async function rejectOrder(orderId) {
    const reason = prompt('دلیل رد سفارش را وارد کنید:');
    if (reason === null) return;
    
    try {
        const response = await fetch('api.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ action: 'reject_order', order_id: orderId, reason: reason })
        });
        const data = await response.json();
        
        if (data.success) {
            showToast('سفارش رد شد', 'success');
            loadLatestOrders();
        } else {
            showToast(data.message, 'error');
        }
    } catch (error) {
        showToast('خطا در رد سفارش', 'error');
    }
}

// ذخیره کد تخفیف
document.getElementById('discountForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    formData.append('action', 'add_discount');
    
    try {
        const response = await fetch('api.php', {
            method: 'POST',
            body: formData
        });
        const data = await response.json();
        
        if (data.success) {
            showToast('کد تخفیف با موفقیت ذخیره شد', 'success');
            closeDiscountModal();
            this.reset();
        } else {
            showToast(data.message, 'error');
        }
    } catch (error) {
        showToast('خطا در ذخیره کد تخفیف', 'error');
    }
});

// ارسال نوتیفیکیشن
document.getElementById('notificationForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    formData.append('action', 'send_notification');
    
    try {
        const response = await fetch('api.php', {
            method: 'POST',
            body: formData
        });
        const data = await response.json();
        
        if (data.success) {
            showToast('پیام با موفقیت ارسال شد', 'success');
            closeNotificationModal();
            this.reset();
        } else {
            showToast(data.message, 'error');
        }
    } catch (error) {
        showToast('خطا در ارسال پیام', 'error');
    }
});

// توابع کمکی
function getStatusClass(status) {
    const classes = {
        'pending': 'bg-yellow-500/20 text-yellow-400',
        'completed': 'bg-green-500/20 text-green-400',
        'rejected': 'bg-red-500/20 text-red-400',
        'cancelled': 'bg-gray-500/20 text-gray-400'
    };
    return classes[status] || classes['pending'];
}

function getStatusText(status) {
    const texts = {
        'pending': 'در انتظار',
        'completed': 'تکمیل شده',
        'rejected': 'رد شده',
        'cancelled': 'لغو شده'
    };
    return texts[status] || status;
}

function getTicketStatusClass(status) {
    const classes = {
        'open': 'bg-blue-500/20 text-blue-400',
        'answered': 'bg-green-500/20 text-green-400',
        'waiting': 'bg-yellow-500/20 text-yellow-400',
        'closed': 'bg-gray-500/20 text-gray-400'
    };
    return classes[status] || classes['open'];
}

function getTicketStatusText(status) {
    const texts = {
        'open': 'باز',
        'answered': 'پاسخ داده شده',
        'waiting': 'در انتظار پاسخ',
        'closed': 'بسته شده'
    };
    return texts[status] || status;
}

function getPriorityGradient(priority) {
    const gradients = {
        'low': 'from-green-500 to-emerald-500',
        'medium': 'from-yellow-500 to-orange-500',
        'high': 'from-red-500 to-pink-500'
    };
    return gradients[priority] || gradients['medium'];
}

function numberFormat(num) {
    return new Intl.NumberFormat('fa-IR').format(num);
}

// لود اولیه داده‌ها
document.addEventListener('DOMContentLoaded', function() {
    loadDashboardStats();
    loadLatestOrders();
    loadLatestTickets();
});
</script>

<?php
/**
 * صفحه مدیریت سفارشات - admin-orders.php
 */
function renderAdminOrders() {
?>
<main class="pr-0 lg:pr-64 pt-16 min-h-screen">
    <div class="p-4 lg:p-8">
        <!-- هدر صفحه -->
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4 mb-8">
            <div>
                <h1 class="text-2xl font-bold">مدیریت سفارشات</h1>
                <p class="text-gray-400 mt-1">مدیریت و بررسی سفارشات کاربران</p>
            </div>
            <div class="flex items-center gap-3">
                <select id="orderStatusFilter" class="bg-white/5 border border-white/10 rounded-xl px-4 py-2 focus:border-primary-500 outline-none">
                    <option value="">همه وضعیت‌ها</option>
                    <option value="pending">در انتظار</option>
                    <option value="completed">تکمیل شده</option>
                    <option value="rejected">رد شده</option>
                </select>
                <select id="paymentMethodFilter" class="bg-white/5 border border-white/10 rounded-xl px-4 py-2 focus:border-primary-500 outline-none">
                    <option value="">همه روش‌ها</option>
                    <option value="card">کارت به کارت</option>
                    <option value="wallet">کیف پول</option>
                </select>
            </div>
        </div>

        <!-- جدول سفارشات -->
        <div class="glass rounded-3xl overflow-hidden">
            <div class="p-6 border-b border-white/10">
                <div class="flex flex-col md:flex-row md:items-center gap-4">
                    <div class="relative flex-1">
                        <input type="text" id="searchOrders" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 pr-12 focus:border-primary-500 outline-none" placeholder="جستجو در سفارشات...">
                        <svg class="w-5 h-5 absolute right-4 top-1/2 -translate-y-1/2 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                        </svg>
                    </div>
                </div>
            </div>
            
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="text-gray-400 text-sm border-b border-white/10">
                            <th class="text-right p-4">شناسه</th>
                            <th class="text-right p-4">کاربر</th>
                            <th class="text-right p-4">محصول</th>
                            <th class="text-right p-4">مبلغ</th>
                            <th class="text-right p-4">روش پرداخت</th>
                            <th class="text-right p-4">وضعیت</th>
                            <th class="text-right p-4">تاریخ</th>
                            <th class="text-center p-4">عملیات</th>
                        </tr>
                    </thead>
                    <tbody id="ordersTable">
                        <!-- داده‌ها با AJAX لود می‌شوند -->
                    </tbody>
                </table>
            </div>
            
            <!-- صفحه‌بندی -->
            <div class="p-4 border-t border-white/10">
                <div class="flex items-center justify-between">
                    <span class="text-gray-400 text-sm" id="ordersCount">نمایش 0 سفارش</span>
                    <div class="flex items-center gap-2" id="ordersPagination">
                        <!-- صفحه‌بندی با جاوااسکریپت -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<!-- Modal جزئیات سفارش -->
<div id="orderDetailModal" class="fixed inset-0 z-50 hidden items-center justify-center p-4 bg-black/50 backdrop-blur-sm">
    <div class="glass rounded-3xl p-6 w-full max-w-2xl animate-scale-in max-h-[90vh] overflow-y-auto">
        <div class="flex items-center justify-between mb-6">
            <h3 class="text-lg font-bold">جزئیات سفارش</h3>
            <button onclick="closeOrderDetailModal()" class="w-8 h-8 rounded-full bg-white/10 flex items-center justify-center hover:bg-red-500/20">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>
        <div id="orderDetailContent">
            <!-- محتوا با AJAX لود می‌شود -->
        </div>
    </div>
</div>

<script>
let currentOrderPage = 1;
const ordersPerPage = 20;

// لود سفارشات
async function loadOrders(page = 1) {
    currentOrderPage = page;
    const status = document.getElementById('orderStatusFilter').value;
    const method = document.getElementById('paymentMethodFilter').value;
    const search = document.getElementById('searchOrders').value;
    
    try {
        const response = await fetch(`api.php?action=admin_get_orders&page=${page}&limit=${ordersPerPage}&status=${status}&method=${method}&search=${encodeURIComponent(search)}`);
        const data = await response.json();
        
        if (data.success) {
            renderOrdersTable(data.orders);
            renderOrdersPagination(data.total, page);
            document.getElementById('ordersCount').textContent = `نمایش ${data.orders.length} از ${data.total} سفارش`;
        }
    } catch (error) {
        console.error('Error loading orders:', error);
    }
}

function renderOrdersTable(orders) {
    const tbody = document.getElementById('ordersTable');
    
    if (orders.length === 0) {
        tbody.innerHTML = `
            <tr>
                <td colspan="8" class="text-center py-12 text-gray-400">
                    <svg class="w-16 h-16 mx-auto mb-4 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    سفارشی یافت نشد
                </td>
            </tr>
        `;
        return;
    }
    
    tbody.innerHTML = orders.map(order => `
        <tr class="border-b border-white/5 hover:bg-white/5">
            <td class="p-4">
                <span class="text-primary-400 font-mono">#${order.id}</span>
            </td>
            <td class="p-4">
                <div class="flex items-center gap-3">
                    <div class="w-8 h-8 rounded-full bg-gradient-to-r from-primary-500 to-secondary-500 flex items-center justify-center text-sm font-bold">
                        ${order.username.charAt(0).toUpperCase()}
                    </div>
                    <div>
                        <div class="font-medium">${order.username}</div>
                        <div class="text-xs text-gray-400">${order.phone || ''}</div>
                    </div>
                </div>
            </td>
            <td class="p-4">
                <div class="font-medium">${order.product_name}</div>
                <div class="text-xs text-gray-400">${order.product_type}</div>
            </td>
            <td class="p-4">
                <span class="font-medium">${numberFormat(order.amount)}</span>
                <span class="text-xs text-gray-400">تومان</span>
            </td>
            <td class="p-4">
                <span class="flex items-center gap-2">
                    ${order.payment_method === 'card' ? `
                        <svg class="w-4 h-4 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                        </svg>
                        کارت به کارت
                    ` : `
                        <svg class="w-4 h-4 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                        </svg>
                        کیف پول
                    `}
                </span>
            </td>
            <td class="p-4">
                <span class="px-3 py-1 rounded-full text-xs ${getStatusClass(order.status)}">
                    ${getStatusText(order.status)}
                </span>
            </td>
            <td class="p-4 text-gray-400">${order.created_at}</td>
            <td class="p-4">
                <div class="flex items-center justify-center gap-2">
                    ${order.status === 'pending' ? `
                        <button onclick="approveOrder(${order.id})" class="w-8 h-8 rounded-lg bg-green-500/20 text-green-400 flex items-center justify-center hover:bg-green-500/30" title="تایید">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                        </button>
                        <button onclick="rejectOrder(${order.id})" class="w-8 h-8 rounded-lg bg-red-500/20 text-red-400 flex items-center justify-center hover:bg-red-500/30" title="رد">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                            </svg>
                        </button>
                    ` : ''}
                    <button onclick="viewOrderDetail(${order.id})" class="w-8 h-8 rounded-lg bg-blue-500/20 text-blue-400 flex items-center justify-center hover:bg-blue-500/30" title="جزئیات">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                        </svg>
                    </button>
                </div>
            </td>
        </tr>
    `).join('');
}

function renderOrdersPagination(total, currentPage) {
    const totalPages = Math.ceil(total / ordersPerPage);
    const container = document.getElementById('ordersPagination');
    
    if (totalPages <= 1) {
        container.innerHTML = '';
        return;
    }
    
    let html = '';
    
    // دکمه قبلی
    html += `
        <button onclick="loadOrders(${currentPage - 1})" ${currentPage === 1 ? 'disabled' : ''} 
            class="w-10 h-10 rounded-lg bg-white/5 flex items-center justify-center hover:bg-white/10 disabled:opacity-50 disabled:cursor-not-allowed">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
            </svg>
        </button>
    `;
    
    // شماره صفحات
    for (let i = 1; i <= totalPages; i++) {
        if (i === currentPage) {
            html += `<button class="w-10 h-10 rounded-lg bg-primary-500 flex items-center justify-center">${i}</button>`;
        } else if (i === 1 || i === totalPages || (i >= currentPage - 2 && i <= currentPage + 2)) {
            html += `<button onclick="loadOrders(${i})" class="w-10 h-10 rounded-lg bg-white/5 flex items-center justify-center hover:bg-white/10">${i}</button>`;
        } else if (i === currentPage - 3 || i === currentPage + 3) {
            html += `<span class="px-2">...</span>`;
        }
    }
    
    // دکمه بعدی
    html += `
        <button onclick="loadOrders(${currentPage + 1})" ${currentPage === totalPages ? 'disabled' : ''} 
            class="w-10 h-10 rounded-lg bg-white/5 flex items-center justify-center hover:bg-white/10 disabled:opacity-50 disabled:cursor-not-allowed">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
            </svg>
        </button>
    `;
    
    container.innerHTML = html;
}

// مشاهده جزئیات سفارش
async function viewOrderDetail(orderId) {
    try {
        const response = await fetch(`api.php?action=admin_get_order_detail&id=${orderId}`);
        const data = await response.json();
        
        if (data.success) {
            const order = data.order;
            document.getElementById('orderDetailContent').innerHTML = `
                <div class="space-y-6">
                    <div class="grid grid-cols-2 gap-4">
                        <div class="glass rounded-xl p-4">
                            <div class="text-gray-400 text-sm mb-1">شناسه سفارش</div>
                            <div class="font-bold text-primary-400">#${order.id}</div>
                        </div>
                        <div class="glass rounded-xl p-4">
                            <div class="text-gray-400 text-sm mb-1">وضعیت</div>
                            <span class="px-3 py-1 rounded-full text-xs ${getStatusClass(order.status)}">
                                ${getStatusText(order.status)}
                            </span>
                        </div>
                    </div>
                    
                    <div class="glass rounded-xl p-4">
                        <h4 class="font-medium mb-3">اطلاعات کاربر</h4>
                        <div class="grid grid-cols-2 gap-4 text-sm">
                            <div>
                                <span class="text-gray-400">نام کاربری:</span>
                                <span class="mr-2">${order.username}</span>
                            </div>
                            <div>
                                <span class="text-gray-400">شماره تماس:</span>
                                <span class="mr-2 font-mono">${order.phone || '-'}</span>
                            </div>
                            <div>
                                <span class="text-gray-400">ایمیل:</span>
                                <span class="mr-2">${order.email || '-'}</span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="glass rounded-xl p-4">
                        <h4 class="font-medium mb-3">جزئیات محصول</h4>
                        <div class="grid grid-cols-2 gap-4 text-sm">
                            <div>
                                <span class="text-gray-400">نام محصول:</span>
                                <span class="mr-2">${order.product_name}</span>
                            </div>
                            <div>
                                <span class="text-gray-400">نوع:</span>
                                <span class="mr-2">${order.product_type}</span>
                            </div>
                            <div>
                                <span class="text-gray-400">مدت زمان:</span>
                                <span class="mr-2">${order.duration} روز</span>
                            </div>
                            <div>
                                <span class="text-gray-400">مبلغ:</span>
                                <span class="mr-2 font-medium">${numberFormat(order.amount)} تومان</span>
                            </div>
                        </div>
                    </div>
                    
                    ${order.payment_method === 'card' && order.receipt_image ? `
                        <div class="glass rounded-xl p-4">
                            <h4 class="font-medium mb-3">تصویر رسید</h4>
                            <img src="${order.receipt_image}" alt="رسید پرداخت" class="max-w-full rounded-xl">
                        </div>
                    ` : ''}
                    
                    ${order.status === 'completed' && order.config ? `
                        <div class="glass rounded-xl p-4">
                            <h4 class="font-medium mb-3">کانفیگ تخصیص داده شده</h4>
                            <div class="bg-black/30 rounded-lg p-3 font-mono text-xs break-all">
                                ${order.config}
                            </div>
                        </div>
                    ` : ''}
                    
                    ${order.status === 'pending' ? `
                        <div class="flex gap-3">
                            <button onclick="approveOrder(${order.id}); closeOrderDetailModal();" class="flex-1 bg-green-500 rounded-xl py-3 font-medium hover:bg-green-600 transition-colors">
                                تایید سفارش
                            </button>
                            <button onclick="rejectOrder(${order.id}); closeOrderDetailModal();" class="flex-1 bg-red-500 rounded-xl py-3 font-medium hover:bg-red-600 transition-colors">
                                رد سفارش
                            </button>
                        </div>
                    ` : ''}
                </div>
            `;
            
            document.getElementById('orderDetailModal').classList.remove('hidden');
            document.getElementById('orderDetailModal').classList.add('flex');
        }
    } catch (error) {
        showToast('خطا در دریافت جزئیات سفارش', 'error');
    }
}

function closeOrderDetailModal() {
    document.getElementById('orderDetailModal').classList.add('hidden');
    document.getElementById('orderDetailModal').classList.remove('flex');
}

// Event Listeners
document.getElementById('orderStatusFilter')?.addEventListener('change', () => loadOrders(1));
document.getElementById('paymentMethodFilter')?.addEventListener('change', () => loadOrders(1));
document.getElementById('searchOrders')?.addEventListener('input', debounce(() => loadOrders(1), 500));

// لود اولیه
document.addEventListener('DOMContentLoaded', () => loadOrders());
</script>
<?php
}
?>