<?php
/**
 * فایل اصلی - روتینگ
 */

require_once 'config.php';
require_once 'functions.php';

// بررسی حالت تعمیرات
if (getSetting('maintenance_mode') == 1 && !isset($_SESSION['is_admin'])) {
    include 'templates/maintenance.php';
    exit;
}

// دریافت صفحه
$page = $_GET['page'] ?? 'home';

// کاربر فعلی
$user = null;
$isLoggedIn = false;
$isAdmin = false;

if (isset($_SESSION['user_id'])) {
    $user = getUserById($_SESSION['user_id']);
    if ($user) {
        $isLoggedIn = true;
        $isAdmin = $user['role'] === 'admin';
        
        // بررسی مسدودی
        if ($user['status'] === 'blocked') {
            session_destroy();
            header('Location: ?page=login&error=blocked');
            exit;
        }
    }
}

// صفحات عمومی (بدون نیاز به لاگین)
$publicPages = ['home', 'login', 'register', 'forgot-password'];

// صفحات ادمین
$adminPages = ['admin', 'admin-users', 'admin-orders', 'admin-configs', 'admin-tickets', 
               'admin-settings', 'admin-referrals', 'admin-payments', 'admin-notifications'];

// بررسی دسترسی
if (in_array($page, $adminPages)) {
    if (!$isLoggedIn || !$isAdmin) {
        header('Location: ?page=login');
        exit;
    }
} elseif (!in_array($page, $publicPages) && !$isLoggedIn) {
    header('Location: ?page=login');
    exit;
}

// ریدایرکت کاربر لاگین شده
if (in_array($page, ['login', 'register']) && $isLoggedIn) {
    header('Location: ?page=' . ($isAdmin ? 'admin' : 'dashboard'));
    exit;
}

?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="theme-color" content="#0F172A">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    
    <title><?php echo getSetting('site_name', 'VPN Shop'); ?></title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="assets/favicon.png">
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'sans': ['Vazirmatn', 'system-ui', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#faf5ff',
                            100: '#f3e8ff',
                            200: '#e9d5ff',
                            300: '#d8b4fe',
                            400: '#c084fc',
                            500: '<?php echo getSetting('primary_color', '#8B5CF6'); ?>',
                            600: '#9333ea',
                            700: '#7e22ce',
                            800: '#6b21a8',
                            900: '#581c87',
                        },
                        secondary: {
                            500: '<?php echo getSetting('secondary_color', '#EC4899'); ?>',
                        }
                    }
                }
            }
        }
    </script>
    
    <!-- Custom Styles -->
    <style>
        * {
            -webkit-tap-highlight-color: transparent;
        }
        
        body {
            font-family: 'Vazirmatn', sans-serif;
            background: linear-gradient(135deg, #0F172A 0%, #1E293B 50%, #0F172A 100%);
            min-height: 100vh;
        }
        
        .glass {
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .glass-dark {
            background: rgba(0, 0, 0, 0.3);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
        }
        
        /* اسکرولبار سفارشی */
        ::-webkit-scrollbar {
            width: 6px;
            height: 6px;
        }
        
        ::-webkit-scrollbar-track {
            background: rgba(255, 255, 255, 0.05);
        }
        
        ::-webkit-scrollbar-thumb {
            background: rgba(255, 255, 255, 0.2);
            border-radius: 3px;
        }
        
        ::-webkit-scrollbar-thumb:hover {
            background: rgba(255, 255, 255, 0.3);
        }
        
        /* انیمیشن‌ها */
        @keyframes scale-in {
            from {
                opacity: 0;
                transform: scale(0.95);
            }
            to {
                opacity: 1;
                transform: scale(1);
            }
        }
        
        @keyframes slide-up {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @keyframes fade-in {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        
        .animate-scale-in {
            animation: scale-in 0.3s ease-out;
        }
        
        .animate-slide-up {
            animation: slide-up 0.3s ease-out;
        }
        
        .animate-fade-in {
            animation: fade-in 0.3s ease-out;
        }
        
        /* Toggle Switch */
        .toggle-switch {
            appearance: none;
            width: 44px;
            height: 24px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 12px;
            position: relative;
            cursor: pointer;
            transition: background 0.3s;
        }
        
        .toggle-switch::before {
            content: '';
            position: absolute;
            width: 20px;
            height: 20px;
            background: white;
            border-radius: 50%;
            top: 2px;
            left: 2px;
            transition: transform 0.3s;
        }
        
        .toggle-switch:checked {
            background: linear-gradient(135deg, #8B5CF6, #EC4899);
        }
        
        .toggle-switch:checked::before {
            transform: translateX(20px);
        }
        
        /* Input focus */
        input:focus, select:focus, textarea:focus {
            box-shadow: 0 0 0 2px rgba(139, 92, 246, 0.3);
        }
        
        /* Safe area for mobile */
        @supports (padding-bottom: env(safe-area-inset-bottom)) {
            .pb-safe {
                padding-bottom: calc(1rem + env(safe-area-inset-bottom));
            }
        }
    </style>
</head>
<body class="text-white antialiased">
    
    <?php
    // هدر
    if ($isLoggedIn) {
        if ($isAdmin && in_array($page, $adminPages)) {
            include 'templates/admin-header.php';
            include 'templates/admin-sidebar.php';
        } else {
            include 'templates/user-header.php';
        }
    }
    
    // محتوای صفحه
    switch ($page) {
        // صفحات عمومی
        case 'home':
            include 'pages/home.php';
            break;
            
        case 'login':
            include 'pages/login.php';
            break;
            
        case 'register':
            include 'pages/register.php';
            break;
        
        // صفحات کاربر
        case 'dashboard':
            renderUserDashboard();
            break;
            
        case 'shop':
            renderUserShop();
            break;
            
        case 'configs':
            include 'pages/user-configs.php';
            break;
            
        case 'wallet':
            renderUserWallet();
            break;
            
        case 'tickets':
            renderUserTickets();
            break;
			case 'notifications':
			renderUserNotifications();
			break;
            
        case 'tutorials':
            renderUserTutorials();
            break;
            
        case 'profile':
            include 'pages/user-profile.php';
            break;
            
        case 'referral':
            include 'pages/user-referral.php';
            break;
            
        case 'orders':
            include 'pages/user-orders.php';
            break;
        
        // صفحات ادمین
        case 'admin':
            include 'pages/admin/dashboard.php';
           // renderAdminDashboard();
            break;
            
        case 'admin-users':
            include 'pages/admin/admin-users.php';
            renderAdminUsers();
            break;
            
        case 'admin-orders':
              include 'pages/admin/admin-orders.php';
            renderAdminOrders();
            break;
            
               case 'admin-configs':
            include 'pages/admin/admin-configs.php';
            renderAdminConfigs();
            break;
      
                case 'admin-tickets':
            include 'pages/admin/admin-tickets.php';
            renderAdminTickets();
            break;
            
            case 'admin-settings':
            include 'pages/admin/admin-settings.php';
            renderAdminSettings();
            break;
   
            case 'admin-discounts':
            include 'pages/admin/admin-discounts.php';
           renderAdminDiscounts();
            break;
            break;
            
             case 'admin-referrals':
            include 'pages/admin/admin-referrals.php';
           renderAdminReferrals();
            break;
            
       case 'admin-payments':
            include 'pages/admin/admin-payments.php';
          	renderAdminPayments();
            break;
            
               case 'admin-tutorials':
            include 'pages/admin/admin-tutorials.php';
           renderAdminTutorials();
            break;
			
			     case 'admin-notifications':
            include 'pages/admin/admin-notifications.php';
            renderAdminNotifications();
            break;

            
        case 'admin-payments':
            include 'pages/admin-payments.php';
            break;
        
        default:
            include 'pages/404.php';
    }
    ?>
    
    <!-- Toast Container -->
    <div id="toastContainer" class="fixed top-4 left-4 right-4 z-[100] flex flex-col items-center gap-2 pointer-events-none"></div>
    
    <!-- Global Scripts -->
    <script>
        // Toast Notification
        function showToast(message, type = 'info') {
            const container = document.getElementById('toastContainer');
            const toast = document.createElement('div');
            
            const colors = {
                success: 'bg-green-500',
                error: 'bg-red-500',
                warning: 'bg-yellow-500',
                info: 'bg-blue-500'
            };
            
            const icons = {
                success: '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>',
                error: '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>',
                warning: '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>',
                info: '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>'
            };
            
            toast.className = `${colors[type]} text-white px-4 py-3 rounded-xl shadow-lg flex items-center gap-3 animate-slide-up pointer-events-auto max-w-sm`;
            toast.innerHTML = `
                <svg class="w-5 h-5 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    ${icons[type]}
                </svg>
                <span class="text-sm font-medium">${message}</span>
            `;
            
            container.appendChild(toast);
            
            setTimeout(() => {
                toast.style.opacity = '0';
                toast.style.transform = 'translateY(-10px)';
                toast.style.transition = 'all 0.3s ease-out';
                setTimeout(() => toast.remove(), 300);
            }, 3000);
        }
        
        // Number Format
        function numberFormat(num) {
            return new Intl.NumberFormat('fa-IR').format(num);
        }
        
        // Debounce
        function debounce(func, wait) {
            let timeout;
            return function executedFunction(...args) {
                const later = () => {
                    clearTimeout(timeout);
                    func(...args);
                };
                clearTimeout(timeout);
                timeout = setTimeout(later, wait);
            };
        }
        
        // Copy to Clipboard
        async function copyToClipboard(text) {
            try {
                await navigator.clipboard.writeText(text);
                showToast('کپی شد', 'success');
                return true;
            } catch (err) {
                // Fallback
                const textarea = document.createElement('textarea');
                textarea.value = text;
                textarea.style.position = 'fixed';
                textarea.style.opacity = '0';
                document.body.appendChild(textarea);
                textarea.select();
                document.execCommand('copy');
                document.body.removeChild(textarea);
                showToast('کپی شد', 'success');
                return true;
            }
        }
        
        // Confirm Dialog
        function confirmAction(message) {
            return confirm(message);
        }
        
        // Format File Size
        function formatFileSize(bytes) {
            if (bytes === 0) return '0 Bytes';
            const k = 1024;
            const sizes = ['Bytes', 'KB', 'MB', 'GB'];
            const i = Math.floor(Math.log(bytes) / Math.log(k));
            return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
        }
        
        // Check if mobile
        function isMobile() {
            return window.innerWidth < 1024;
        }
        
        // PWA Install
        let deferredPrompt;
        window.addEventListener('beforeinstallprompt', (e) => {
            e.preventDefault();
            deferredPrompt = e;
        });
    </script>
</body>
</html>