<?php
/**
 * فایل تنظیمات اصلی
 */

// تنظیمات خطا
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/logs/error.log');

// منطقه زمانی
date_default_timezone_set('Asia/Tehran');

// تنظیمات دیتابیس
define('DB_HOST', 'localhost');
define('DB_NAME', 'funweb_vippr');
define('DB_USER', 'funweb_vippr');
define('DB_PASS', 'yli1zkQj(s1)Wm!u');
define('DB_CHARSET', 'utf8mb4');

// تنظیمات سایت
define('SITE_URL', 'https://funweb.ir/vip');
define('SITE_NAME', 'VPN Shop');

// تنظیمات امنیتی
define('SESSION_LIFETIME', 86400); // 24 ساعت
define('CSRF_TOKEN_NAME', 'csrf_token');
define('PASSWORD_MIN_LENGTH', 6);

// تنظیمات آپلود
define('UPLOAD_MAX_SIZE', 2 * 1024 * 1024); // 2MB
define('UPLOAD_ALLOWED_TYPES', ['jpg', 'jpeg', 'png', 'gif', 'pdf', 'zip']);
define('UPLOAD_PATH', __DIR__ . '/uploads/');

// تنظیمات صفحه‌بندی
define('ITEMS_PER_PAGE', 20);

// کلاس اتصال به دیتابیس
class Database {
    private static $instance = null;
    private $pdo;
    
    private function __construct() {
        try {
            $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
            $options = [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
                PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES " . DB_CHARSET
            ];
            $this->pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
        } catch (PDOException $e) {
            error_log("Database connection failed: " . $e->getMessage());
            die("خطا در اتصال به دیتابیس");
        }
    }
    
    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    public function getConnection() {
        return $this->pdo;
    }
    
    public function query($sql, $params = []) {
        $stmt = $this->pdo->prepare($sql);
        $stmt->execute($params);
        return $stmt;
    }
    
    public function fetch($sql, $params = []) {
        return $this->query($sql, $params)->fetch();
    }
    
    public function fetchAll($sql, $params = []) {
        return $this->query($sql, $params)->fetchAll();
    }
    
    public function insert($table, $data) {
        $columns = implode(', ', array_keys($data));
        $placeholders = implode(', ', array_fill(0, count($data), '?'));
        $sql = "INSERT INTO {$table} ({$columns}) VALUES ({$placeholders})";
        $this->query($sql, array_values($data));
        return $this->pdo->lastInsertId();
    }
    
    public function update($table, $data, $where, $whereParams = []) {
        $set = implode(' = ?, ', array_keys($data)) . ' = ?';
        $sql = "UPDATE {$table} SET {$set} WHERE {$where}";
        $params = array_merge(array_values($data), $whereParams);
        return $this->query($sql, $params)->rowCount();
    }
    
    public function delete($table, $where, $params = []) {
        $sql = "DELETE FROM {$table} WHERE {$where}";
        return $this->query($sql, $params)->rowCount();
    }
}

// شروع Session
if (session_status() === PHP_SESSION_NONE) {
    ini_set('session.cookie_httponly', 1);
    ini_set('session.cookie_secure', isset($_SERVER['HTTPS']));
    ini_set('session.gc_maxlifetime', SESSION_LIFETIME);
    session_start();
}

// تابع دسترسی سریع به دیتابیس
function db() {
    return Database::getInstance();
}

// تابع تبدیل تاریخ به شمسی
function toJalali($date, $format = 'Y/m/d H:i') {
    if (empty($date)) return '-';
    
    $timestamp = is_numeric($date) ? $date : strtotime($date);
    
    // استفاده از کتابخانه jdf یا تبدیل ساده
    $g_days_in_month = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
    $j_days_in_month = [31, 31, 31, 31, 31, 31, 30, 30, 30, 30, 30, 29];
    
    $gy = (int)date('Y', $timestamp);
    $gm = (int)date('m', $timestamp);
    $gd = (int)date('d', $timestamp);
    
    $g_day_no = 0;
    for ($i = 0; $i < $gy - 1; $i++) {
        $g_day_no += 365 + (($i % 4 == 3) ? 1 : 0);
    }
    for ($i = 0; $i < $gm - 1; $i++) {
        $g_day_no += $g_days_in_month[$i];
    }
    if ($gm > 2 && $gy % 4 == 0) $g_day_no++;
    $g_day_no += $gd;
    
    $j_day_no = $g_day_no - 226894;
    $j_np = (int)($j_day_no / 12053);
    $j_day_no %= 12053;
    
    $jy = 979 + 33 * $j_np + 4 * (int)($j_day_no / 1461);
    $j_day_no %= 1461;
    
    if ($j_day_no >= 366) {
        $jy += (int)(($j_day_no - 1) / 365);
        $j_day_no = ($j_day_no - 1) % 365;
    }
    
    $jm = 0;
    for ($i = 0; $i < 11 && $j_day_no >= $j_days_in_month[$i]; $i++) {
        $j_day_no -= $j_days_in_month[$i];
        $jm++;
    }
    $jm++;
    $jd = $j_day_no + 1;
    
    $result = str_replace('Y', $jy, $format);
    $result = str_replace('m', str_pad($jm, 2, '0', STR_PAD_LEFT), $result);
    $result = str_replace('d', str_pad($jd, 2, '0', STR_PAD_LEFT), $result);
    $result = str_replace('H', date('H', $timestamp), $result);
    $result = str_replace('i', date('i', $timestamp), $result);
    
    return $result;
}

// تابع فرمت عدد فارسی
function faNumber($number) {
    $persian = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
    $english = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
    return str_replace($english, $persian, $number);
}

// تابع لاگ
function writeLog($action, $description = '', $userId = null) {
    db()->insert('logs', [
        'user_id' => $userId ?? ($_SESSION['user_id'] ?? null),
        'action' => $action,
        'description' => $description,
        'ip_address' => $_SERVER['REMOTE_ADDR'] ?? '',
        'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? ''
    ]);
}