<?php require_once 'config.php'; ?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>اسکنر کانال - <?= SITE_NAME ?></title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazirmatn@v33.003/Vazirmatn-font-face.css" rel="stylesheet">
    
    <style>
        * { font-family: 'Vazirmatn', system-ui, sans-serif; }
        
        :root {
            --bg-dark: #0f0f23;
            --bg-card: #1a1a2e;
        }
        
        body {
            background: linear-gradient(135deg, var(--bg-dark) 0%, #16162a 50%, #1a1a35 100%);
            min-height: 100vh;
            color: white;
        }
        
        .glass {
            background: rgba(26, 26, 46, 0.8);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .glass-card {
            background: linear-gradient(145deg, rgba(26, 26, 46, 0.9), rgba(37, 37, 61, 0.6));
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.08);
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%);
        }
        
        .btn-primary:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }
        
        @keyframes spin {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }
        
        .animate-spin { animation: spin 1s linear infinite; }
    </style>
</head>
<body class="pb-20">
    <!-- Header -->
    <header class="glass sticky top-0 z-50 px-4 py-4">
        <div class="max-w-lg mx-auto flex items-center gap-3">
            <a href="index.php" class="p-2 rounded-lg bg-white/5 hover:bg-white/10 transition">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                </svg>
            </a>
            <div>
                <h1 class="text-xl font-bold">اسکنر کانال</h1>
                <p class="text-xs text-gray-400">استخراج کانفیگ از تلگرام</p>
            </div>
        </div>
    </header>

    <main class="px-4 py-6">
        <div class="max-w-lg mx-auto space-y-6">
            
            <!-- Input Section -->
    <!-- بخش Input در scanner.php - جایگزین کن -->

<div class="glass-card rounded-2xl p-6">
    <label class="block text-sm font-medium mb-3">
        🔗 آدرس کانال‌ها
        <span class="text-gray-400 text-xs">(هر خط یک کانال)</span>
    </label>
    
    <textarea 
        id="channelInput"
        rows="5"
        class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-sm focus:outline-none focus:border-indigo-500 transition resize-none"
        placeholder="@channel_name
https://t.me/channel_name
channel_name"
    ></textarea>
    
    <!-- تعداد پست -->
    <div class="mt-4">
        <label class="block text-sm font-medium mb-2">
            📊 تعداد پست برای بررسی
        </label>
        <div class="flex items-center gap-3">
            <input 
                type="range" 
                id="postCount" 
                min="10" 
                max="100" 
                value="30"
                class="flex-1"
                oninput="document.getElementById('postCountValue').textContent = this.value"
            >
            <span id="postCountValue" class="text-indigo-400 font-bold w-10 text-center">30</span>
        </div>
    </div>
    
    <div class="mt-4 flex gap-3">
        <button 
            id="scanBtn"
            onclick="startScan()"
            class="btn-primary flex-1 py-3 rounded-xl font-bold flex items-center justify-center gap-2"
        >
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
            </svg>
            شروع اسکن
        </button>
        
        <button 
            onclick="clearInput()"
            class="px-4 py-3 rounded-xl bg-white/5 hover:bg-white/10 transition"
            title="پاک کردن"
        >
            🗑️
        </button>
    </div>
</div>
            <!-- Popular Channels -->
            <div class="glass-card rounded-2xl p-6">
                <h3 class="font-bold mb-4 flex items-center gap-2">
                    ⭐ کانال‌های پیشنهادی
                </h3>
                <div class="grid grid-cols-2 gap-2">
                    <button onclick="addChannel('v2rayng_fa')" class="text-right px-3 py-2 rounded-lg bg-white/5 hover:bg-white/10 transition text-sm">
                        V2RayNG فارسی
                    </button>
                    <button onclick="addChannel('vpn_configs')" class="text-right px-3 py-2 rounded-lg bg-white/5 hover:bg-white/10 transition text-sm">
                        VPN Configs
                    </button>
                    <button onclick="addChannel('free_v2ray')" class="text-right px-3 py-2 rounded-lg bg-white/5 hover:bg-white/10 transition text-sm">
                        Free V2Ray
                    </button>
                    <button onclick="addChannel('proxy_mtm')" class="text-right px-3 py-2 rounded-lg bg-white/5 hover:bg-white/10 transition text-sm">
                        Proxy MTM
                    </button>
                </div>
            </div>

            <!-- Results -->
            <div id="results" class="space-y-4 hidden">
                <h3 class="font-bold flex items-center gap-2">
                    📊 نتایج اسکن
                </h3>
                <div id="resultsList"></div>
            </div>

        </div>
        
    </main>

    <!-- Bottom Navigation -->
    <nav class="fixed bottom-0 left-0 right-0 glass px-4 py-3">
        <div class="max-w-lg mx-auto flex justify-around">
            <a href="index.php" class="flex flex-col items-center gap-1 text-gray-400 hover:text-white transition">
                <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24">
                    <path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z"/>
                </svg>
                <span class="text-xs">خانه</span>
            </a>
            <a href="scanner.php" class="flex flex-col items-center gap-1 text-indigo-400">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                </svg>
                <span class="text-xs">اسکنر</span>
            </a>
            <a href="api/subscription.php" class="flex flex-col items-center gap-1 text-gray-400 hover:text-white transition">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"/>
                </svg>
                <span class="text-xs">اشتراک</span>
            </a>
        </div>
    </nav>

    <script>
        function addChannel(channel) {
            const input = document.getElementById('channelInput');
            const current = input.value.trim();
            if (current) {
                input.value = current + '\n' + channel;
            } else {
                input.value = channel;
            }
        }
        
        function clearInput() {
            document.getElementById('channelInput').value = '';
            document.getElementById('results').classList.add('hidden');
        }
        
        async function startScan() {
            const input = document.getElementById('channelInput');
            const btn = document.getElementById('scanBtn');
            const results = document.getElementById('results');
            const resultsList = document.getElementById('resultsList');
            
            const channels = input.value.trim().split('\n').filter(c => c.trim());
            
            if (channels.length === 0) {
                alert('لطفاً حداقل یک کانال وارد کنید');
                return;
            }
            
            // Disable button
            btn.disabled = true;
            btn.innerHTML = `
                <svg class="w-5 h-5 animate-spin" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                </svg>
                در حال اسکن...
            `;
            
            try {
                const response = await fetch('api/scan.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ channels })
                });
                
                const data = await response.json();
                
                results.classList.remove('hidden');
                resultsList.innerHTML = '';
                
                // Summary
                resultsList.innerHTML += `
                    <div class="glass-card rounded-xl p-4 mb-4">
                        <div class="grid grid-cols-3 gap-4 text-center">
                            <div>
                                <div class="text-2xl font-bold text-indigo-400">${data.channels_scanned}</div>
                                <div class="text-xs text-gray-400">کانال</div>
                            </div>
                            <div>
                                <div class="text-2xl font-bold text-green-400">${data.configs_found}</div>
                                <div class="text-xs text-gray-400">کانفیگ</div>
                            </div>
                            <div>
                                <div class="text-2xl font-bold text-purple-400">${data.configs_new || 0}</div>
                                <div class="text-xs text-gray-400">جدید</div>
                            </div>
                        </div>
                    </div>
                `;
                
                // Details
                data.details.forEach(detail => {
                    const statusClass = detail.status === 'success' ? 'text-green-400' : 'text-red-400';
                    const statusIcon = detail.status === 'success' ? '✓' : '✗';
                    
                    resultsList.innerHTML += `
                        <div class="glass-card rounded-xl p-4 flex items-center justify-between">
                            <div>
                                <div class="font-medium">@${detail.channel}</div>
                                <div class="text-xs text-gray-400">${detail.title || ''}</div>
                            </div>
                            <div class="text-left">
                                <span class="${statusClass}">${statusIcon}</span>
                                ${detail.status === 'success' ? `<span class="text-sm text-gray-400">${detail.configs} کانفیگ</span>` : ''}
                            </div>
                        </div>
                    `;
                });
                
            } catch (error) {
                alert('خطا در اسکن: ' + error.message);
            } finally {
                btn.disabled = false;
                btn.innerHTML = `
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                    </svg>
                    شروع اسکن
                `;
            }
        }
    </script>
</body>
</html>