<?php
// api/configs.php

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

require_once '../config.php';
require_once '../includes/Database.php';

try {
    $db = Database::getInstance();
    
    // فیلترها
    $filters = [
        'protocol' => $_GET['protocol'] ?? null,
        'channel' => $_GET['channel'] ?? null,
        'light_mode' => isset($_GET['light_mode']) && $_GET['light_mode'] === '1',
        'limit' => min((int)($_GET['limit'] ?? 50), 200),
        'offset' => (int)($_GET['offset'] ?? 0)
    ];
    
    $configs = $db->getConfigs($filters);
    $stats = $db->getStats();
    
    echo json_encode([
        'success' => true,
        'total' => count($configs),
        'stats' => $stats,
        'configs' => $configs
    ], JSON_UNESCAPED_UNICODE);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}